/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.PluginInformation;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.util.AmpsEmailSubscriber;
import com.atlassian.maven.plugins.amps.util.AmpsPluginVersionChecker;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.UpdateChecker;
import com.atlassian.maven.plugins.updater.LocalSdk;
import com.atlassian.maven.plugins.updater.SdkResource;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractAmpsMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    private List<MavenProject> reactor;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager buildPluginManager;
    @Parameter(property="plugin.artifactId", required=true, readonly=true)
    private String pluginArtifactId;
    @Parameter(property="plugin.version", required=true, readonly=true)
    private String pluginVersion;
    private MavenContext mavenContext;
    private MavenGoals mavenGoals;
    @Component
    private SdkResource sdkResource;
    @Component
    private LocalSdk localSdk;
    @Component
    private UpdateChecker updateChecker;
    @Parameter(property="force.update.check", defaultValue="false")
    private boolean forceUpdateCheck;
    @Parameter(property="skip.amps.pom.check", defaultValue="false")
    private boolean skipAmpsPomCheck;
    @Parameter(property="closure.js.compiler", defaultValue="false")
    protected boolean closureJsCompiler;
    @Component
    private AmpsPluginVersionChecker ampsPluginVersionChecker;
    @Component
    private AmpsEmailSubscriber ampsEmailSubscriber;
    @Parameter(property="skipAllPrompts", defaultValue="false")
    private boolean skipAllPrompts;
    @Parameter(property="useFastdevCli", defaultValue="true")
    private boolean useFastdevCli;
    @Parameter
    protected List<ProductArtifact> testBundleExcludes = new ArrayList<ProductArtifact>();
    @Parameter(property="buildTestPlugin", defaultValue="false")
    private boolean buildTestPlugin;
    @Parameter(property="excludeAllTestDependencies", defaultValue="false")
    protected boolean excludeAllTestDependencies;
    @Parameter(property="offline", defaultValue="${settings.offline}")
    protected boolean offline;
    @Parameter(property="version.override.path")
    private String versionOverridesPath;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;

    protected MavenContext getMavenContext() {
        if (this.mavenContext == null) {
            this.mavenContext = new MavenContext(this.project, this.reactor, this.session, this.buildPluginManager, this.getLog());
        }
        this.mavenContext.setVersionOverridesPath(this.versionOverridesPath);
        return this.mavenContext;
    }

    protected MavenGoals getMavenGoals() {
        if (this.mavenGoals == null) {
            this.mavenGoals = new MavenGoals(this.getMavenContext());
        }
        return this.mavenGoals;
    }

    protected PluginInformation getPluginInformation() {
        if (this.pluginArtifactId == null) {
            return new PluginInformation("amps", "");
        }
        String productId = this.pluginArtifactId.replaceAll("maven-(.*)-plugin", "$1");
        return new PluginInformation(productId, this.pluginVersion);
    }

    protected UpdateChecker getUpdateChecker() throws MojoExecutionException {
        this.updateChecker.setCurrentVersion(this.getSdkVersion());
        this.updateChecker.setForceCheck(this.forceUpdateCheck);
        boolean skipCheck = this.shouldSkipPrompts() || this.offline;
        this.updateChecker.setSkipCheck(skipCheck);
        return this.updateChecker;
    }

    protected AmpsPluginVersionChecker getAmpsPluginVersionChecker() {
        this.ampsPluginVersionChecker.skipPomCheck(this.skipAmpsPomCheck);
        if (this.shouldSkipPrompts()) {
            this.ampsPluginVersionChecker.skipPomCheck(true);
        }
        return this.ampsPluginVersionChecker;
    }

    protected AmpsEmailSubscriber getAmpsEmailSubscriber() {
        return this.ampsEmailSubscriber;
    }

    protected String getSdkVersion() {
        String sdkVersion = System.getenv("ATLAS_VERSION");
        return sdkVersion != null ? sdkVersion : this.getPluginInformation().getVersion();
    }

    protected boolean shouldBuildTestPlugin() {
        boolean shouldBuild = false;
        if (this.buildTestPlugin) {
            shouldBuild = true;
        } else if (ProjectUtils.shouldDeployTestJar(this.getMavenContext())) {
            shouldBuild = true;
        }
        return shouldBuild;
    }

    protected boolean shouldSkipPrompts() {
        return this.skipAllPrompts;
    }
}

