/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.maven.plugins.amps.util.ant.AntJavaExecutorThread;
import com.atlassian.maven.plugins.amps.util.ant.JavaTaskFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.taskdefs.Java;

public class CtkServerProductHandler
implements ProductHandler {
    private static final String CTK_SERVER_ARTIFACT_MATCHER = "federated-api-ctk-server-.*\\.jar";
    private final MavenContext context;
    private final MavenGoals goals;
    private final JavaTaskFactory javaTaskFactory;
    private final Log log;

    public CtkServerProductHandler(MavenContext context, MavenGoals goals) {
        this.context = context;
        this.goals = goals;
        this.javaTaskFactory = new JavaTaskFactory(context.getLog());
        this.log = context.getLog();
    }

    @Override
    public String getId() {
        return "ctk-server";
    }

    @Override
    public int getDefaultHttpPort() {
        return 8990;
    }

    @Override
    public String getDefaultContextPath() {
        return "/";
    }

    @Override
    public int start(Product product) throws MojoExecutionException {
        this.unpackContainer(product);
        this.startContainer(product);
        return product.getHttpPort();
    }

    @Override
    public void stop(Product product) throws MojoExecutionException {
        try {
            this.stopContainer(product);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to send stop command to CTK server", (Exception)e);
        }
    }

    @Override
    public String getDefaultContainerId() {
        return "ctk-server";
    }

    @Override
    public File getSnapshotDirectory(Product product) {
        return this.getBaseDirectory(product);
    }

    @Override
    public File getHomeDirectory(Product product) {
        return this.getBaseDirectory(product);
    }

    @Override
    public File getBaseDirectory(Product product) {
        return ProjectUtils.createDirectory(new File(this.context.getProject().getBuild().getDirectory(), "ctk-server-" + product.getVersion()));
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product product) {
        return Collections.emptyList();
    }

    @Override
    public List<File> getConfigFiles(Product product, File snapshotCopyDir) {
        return Collections.emptyList();
    }

    @Override
    public void createHomeZip(File homeDirectory, File targetZip, Product product) throws MojoExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File homeDirectory) throws MojoExecutionException, IOException {
        throw new UnsupportedOperationException();
    }

    private void unpackContainer(Product product) throws MojoExecutionException {
        File baseDirectory = this.getBaseDirectory(product);
        String[] directoryContents = baseDirectory.list();
        if (directoryContents == null || directoryContents.length == 0) {
            File serverDistributionArtifactFile = this.copyServerArtifactToOutputDirectory(product);
            this.unpackServerArtifact(serverDistributionArtifactFile, baseDirectory);
            this.deleteServerArtifact(serverDistributionArtifactFile);
        } else {
            this.log.debug((CharSequence)("CTK Server " + product.getVersion() + " already unpacked."));
        }
    }

    private File copyServerArtifactToOutputDirectory(Product product) throws MojoExecutionException {
        File buildDirectory = new File(this.context.getProject().getBuild().getDirectory());
        ProductArtifact serverDistributionArtifact = this.getServerDistributionArtifact(product);
        String filename = String.format("%s-%s.%s", serverDistributionArtifact.getArtifactId(), serverDistributionArtifact.getVersion(), serverDistributionArtifact.getType());
        return this.goals.copyZip(buildDirectory, serverDistributionArtifact, filename);
    }

    private void unpackServerArtifact(File serverDistributionArtifactFile, File serverDirectory) throws MojoExecutionException {
        try {
            ZipUtils.unzip(serverDistributionArtifactFile, serverDirectory.getPath(), 0);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to extract CTK server distribution: " + serverDistributionArtifactFile, (Exception)ex);
        }
    }

    private void deleteServerArtifact(File serverDistributionArtifactFile) {
        this.log.debug((CharSequence)("Deleting CTK server distribution artifact: " + serverDistributionArtifactFile.getPath()));
        if (!serverDistributionArtifactFile.delete()) {
            this.log.warn((CharSequence)("Failed to delete CTK server distribution artifact: " + serverDistributionArtifactFile.getPath()));
        }
    }

    private void startContainer(Product product) {
        Map<String, String> systemProperties = this.getSystemProperties(product);
        Java java = this.javaTaskFactory.newJavaTask(JavaTaskFactory.output(product.getOutput()).systemProperties(systemProperties).jvmArgs(product.getJvmArgs() + product.getDebugArgs()));
        java.setDir(this.getBaseDirectory(product));
        java.setJar(this.findServerJar(product));
        java.createArg().setValue("--host");
        java.createArg().setValue(product.getServer());
        java.createArg().setValue("--port");
        java.createArg().setValue(Integer.toString(product.getHttpPort()));
        AntJavaExecutorThread javaThread = new AntJavaExecutorThread(java);
        javaThread.start();
    }

    private ProductArtifact getServerDistributionArtifact(Product ctx) {
        return new ProductArtifact("com.atlassian.federation", "federated-api-ctk-server-distribution", ctx.getVersion(), "zip");
    }

    private Map<String, String> getSystemProperties(Product product) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : product.getSystemPropertyVariables().entrySet()) {
            map.put(entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    private File findServerJar(Product product) {
        File baseDirectory = this.getBaseDirectory(product);
        Object[] files = baseDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(CtkServerProductHandler.CTK_SERVER_ARTIFACT_MATCHER);
            }
        });
        if (files.length == 0) {
            throw new IllegalStateException("CTK server jar file not found in: " + baseDirectory + " (expected file to match: " + CTK_SERVER_ARTIFACT_MATCHER + ")");
        }
        if (files.length == 1) {
            return files[0];
        }
        throw new IllegalStateException("Found too CTK server jar files, expected only one: " + Arrays.toString(files));
    }

    private void stopContainer(Product product) throws IOException, MojoExecutionException {
        URL url = new URL(product.getProtocol(), product.getServer(), product.getHttpPort(), product.getContextPath());
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setConnectTimeout(product.getShutdownTimeout());
        httpConnection.setRequestMethod("DELETE");
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            throw new MojoExecutionException("CTK server didn't understand stop command; received HTTP response code: " + responseCode);
        }
    }
}

