/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.minifier;

import com.atlassian.maven.plugins.amps.util.minifier.GoogleClosureOptionsHandler;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.SourceFile;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class GoogleClosureJSMinifier {
    private static CompilerOptions options;

    public static void setOptions(Map<String, String> closureOptions, Log log) {
        GoogleClosureOptionsHandler googleClosureOptionsHandler = new GoogleClosureOptionsHandler(log);
        if (closureOptions != null && !closureOptions.isEmpty()) {
            for (String optionName : closureOptions.keySet()) {
                googleClosureOptionsHandler.setOption(optionName, closureOptions.get(optionName));
            }
        }
        options = googleClosureOptionsHandler.getCompilerOptions();
    }

    public static String compile(String code) {
        Compiler compiler = new Compiler();
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        JSSourceFile extern = JSSourceFile.fromCode((String)"externs.js", (String)"function alert(x) {}");
        JSSourceFile input = JSSourceFile.fromCode((String)"input.js", (String)code);
        compiler.compile((SourceFile)extern, (SourceFile)input, options);
        return compiler.toSource();
    }
}

