/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ZipUtils {
    public static void untargz(File targz, String destDir) throws IOException {
        ZipUtils.untargz(targz, destDir, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void untargz(File targz, String destDir, int leadingPathSegmentsToTrim) throws IOException {
        FileInputStream fin = new FileInputStream(targz);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)fin);
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzIn);
        try {
            while (true) {
                TarArchiveEntry entry;
                if ((entry = tarIn.getNextTarEntry()) == null) {
                    return;
                }
                File entryFile = new File(destDir + File.separator + ZipUtils.trimPathSegments(entry.getName(), leadingPathSegmentsToTrim));
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                if (!entryFile.getParentFile().exists()) {
                    entryFile.getParentFile().mkdirs();
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(entryFile);
                    IOUtils.copy((InputStream)tarIn, (OutputStream)fos);
                    if ((entry.getMode() & 0x40) != 0) {
                        entryFile.setExecutable(true);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fin);
            IOUtils.closeQuietly((InputStream)tarIn);
            IOUtils.closeQuietly((InputStream)gzIn);
        }
    }

    public static void unzip(File zipFile, String destDir) throws IOException {
        ZipUtils.unzip(zipFile, destDir, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, String destDir, int leadingPathSegmentsToTrim) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
                String zipPath = ZipUtils.trimPathSegments(zipEntry.getName(), leadingPathSegmentsToTrim);
                File file = new File(destDir + "/" + zipPath);
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    is = zip.getInputStream(zipEntry);
                    fos = new FileOutputStream(file);
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    if ((zipEntry.getUnixMode() & 0x40) != 0) {
                        file.setExecutable(true);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)fos);
                file.setLastModified(zipEntry.getTime());
            }
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countNestingLevel(File zip) throws ZipException, IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            List<String> filenames = ZipUtils.toList(zipFile.getEntries());
            int n = ZipUtils.countNestingLevel(filenames);
            return n;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static int countNestingLevel(List<String> filenames) {
        String prefix = StringUtils.getCommonPrefix((String[])filenames.toArray(new String[filenames.size()]));
        if (!prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.lastIndexOf("/") + 1);
        }
        if (filenames.remove(prefix)) {
            return ZipUtils.countNestingLevel(filenames);
        }
        filenames.clear();
        return StringUtils.countMatches((String)prefix, (String)"/");
    }

    private static List<String> toList(Enumeration<? extends ZipEntry> entries) {
        ArrayList filenamesList = Lists.newArrayList();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            filenamesList.add(zipEntry.getName());
        }
        return filenamesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File zipFile, File srcDir, String prefix) throws IOException {
        ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));
        try {
            ZipUtils.addZipPrefixes(srcDir, out, prefix);
            ZipUtils.addZipDir(srcDir, out, prefix);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private static void addZipPrefixes(File dirObj, ZipArchiveOutputStream out, String prefix) throws IOException {
        String entryPrefix = ZipUtils.ensurePrefixWithSlash(dirObj, prefix);
        String[] prefixes = entryPrefix.split("/");
        String lastPrefix = "";
        for (int i = 0; i < prefixes.length; ++i) {
            ZipArchiveEntry entry = new ZipArchiveEntry(lastPrefix + prefixes[i] + "/");
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            lastPrefix = prefixes[i] + "/";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addZipDir(File dirObj, ZipArchiveOutputStream out, String prefix) throws IOException {
        File[] files = dirObj.listFiles();
        byte[] tmpBuf = new byte[1024];
        String entryPrefix = ZipUtils.ensurePrefixWithSlash(dirObj, prefix);
        String entryName = "";
        for (int i = 0; i < files.length; ++i) {
            File currentFile = files[i];
            if (currentFile.isDirectory()) {
                entryName = entryPrefix + currentFile.getName() + "/";
                ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                out.putArchiveEntry((ArchiveEntry)entry);
                out.closeArchiveEntry();
                ZipUtils.addZipDir(currentFile, out, entryName);
                continue;
            }
            if (!currentFile.isFile()) continue;
            entryName = entryPrefix + currentFile.getName();
            FileInputStream in = new FileInputStream(currentFile.getAbsolutePath());
            try {
                int len;
                ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                out.putArchiveEntry((ArchiveEntry)entry);
                if (currentFile.canExecute()) {
                    entry.setUnixMode(448);
                }
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                out.closeArchiveEntry();
                continue;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private static String ensurePrefixWithSlash(File rootDir, String prefix) {
        String entryPrefix = prefix;
        if (StringUtils.isNotBlank((String)entryPrefix) && !entryPrefix.equals("/")) {
            if (entryPrefix.charAt(0) == '/') {
                entryPrefix = entryPrefix.substring(1);
            }
            if (entryPrefix.charAt(entryPrefix.length() - 1) != '/') {
                entryPrefix = entryPrefix + "/";
            }
        } else {
            entryPrefix = rootDir.getName() + "/";
        }
        return entryPrefix;
    }

    private static String trimPathSegments(String zipPath, int trimLeadingPathSegments) {
        int nextSlash;
        int startIndex = 0;
        for (int i = 0; i < trimLeadingPathSegments && (nextSlash = zipPath.indexOf("/", startIndex)) != -1; ++i) {
            startIndex = nextSlash + 1;
        }
        return zipPath.substring(startIndex);
    }
}

