/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class JiraDatabasePostgresImpl
extends AbstractJiraDatabase {
    private static final String DROP_DATABASE = "DROP DATABASE IF EXISTS \"%s\";";
    private static final String DROP_USER = "DROP USER IF EXISTS \"%s\";";
    private static final String CREATE_DATABASE = "CREATE DATABASE \"%s\";";
    private static final String CREATE_USER = "CREATE USER \"%s\" WITH PASSWORD '%s' ;";
    private static final String GRANT_PERMISSION = "GRANT ALL PRIVILEGES ON DATABASE \"%s\" TO \"%s\";";

    public JiraDatabasePostgresImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String dropDatabase() throws MojoExecutionException {
        return String.format(DROP_DATABASE, this.getDatabaseName(this.getDataSource().getUrl()));
    }

    @Override
    protected String dropUser() {
        return String.format(DROP_USER, this.getDataSource().getUsername());
    }

    @Override
    protected String createDatabase() throws MojoExecutionException {
        return String.format(CREATE_DATABASE, this.getDatabaseName(this.getDataSource().getUrl()));
    }

    @Override
    protected String createUser() {
        return String.format(CREATE_USER, this.getDataSource().getUsername(), this.getDataSource().getPassword());
    }

    @Override
    protected String grantPermissionForUser() throws MojoExecutionException {
        return String.format(GRANT_PERMISSION, this.getDatabaseName(this.getDataSource().getUrl()), this.getDataSource().getUsername());
    }

    @Override
    protected String getDatabaseName(String url) throws MojoExecutionException {
        String databaseName = "";
        try {
            Class.forName(this.getDataSource().getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load Postgresql database library to classpath");
        }
        try {
            Driver driver = DriverManager.getDriver(url);
            DriverPropertyInfo[] driverPropertyInfos = driver.getPropertyInfo(url, null);
            if (null != driverPropertyInfos) {
                for (DriverPropertyInfo driverPropertyInfo : driverPropertyInfos) {
                    if (!"PGDBNAME".equals(driverPropertyInfo.name)) continue;
                    databaseName = driverPropertyInfo.value;
                    break;
                }
            }
            if (null == databaseName) {
                Properties driverProps = new Properties();
                if (null != (driverProps = this.parseURL(url, driverProps))) {
                    databaseName = driverProps.getProperty("PGDBNAME");
                }
            }
        }
        catch (SQLException e) {
            throw new MojoExecutionException("No suitable driver");
        }
        return databaseName;
    }

    @Override
    public Xpp3Dom getPluginConfiguration() throws MojoExecutionException {
        String sql = this.dropDatabase() + this.dropUser() + this.createDatabase() + this.createUser() + this.grantPermissionForUser();
        Xpp3Dom pluginConfiguration = this.baseConfiguration();
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        return pluginConfiguration;
    }

    public Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps = new Properties(defaults);
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        if (!l_urlServer.startsWith("jdbc:postgresql:")) {
            return null;
        }
        if ((l_urlServer = l_urlServer.substring("jdbc:postgresql:".length())).startsWith("//")) {
            int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                return null;
            }
            urlProps.setProperty("PGDBNAME", l_urlServer.substring(slash + 1));
            String[] addresses = l_urlServer.substring(0, slash).split(",");
            StringBuffer hosts = new StringBuffer();
            StringBuffer ports = new StringBuffer();
            for (int addr = 0; addr < addresses.length; ++addr) {
                String address = addresses[addr];
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                    ports.append(portStr);
                    hosts.append(address.subSequence(0, portIdx));
                } else {
                    ports.append("5432");
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty("PGPORT", ports.toString());
            urlProps.setProperty("PGHOST", hosts.toString());
        } else {
            urlProps.setProperty("PGPORT", "5432");
            urlProps.setProperty("PGHOST", "localhost");
            urlProps.setProperty("PGDBNAME", l_urlServer);
        }
        String[] args = l_urlArgs.split("&");
        for (int i = 0; i < args.length; ++i) {
            String token = args[i];
            if (token.length() == 0) continue;
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, l_pos), token.substring(l_pos + 1));
        }
        return urlProps;
    }
}

