/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class JiraDatabaseOracleImpl
extends AbstractJiraDatabase {
    private static final String DROP_DATABASE = "";
    private static final String DROP_USER = "DROP USER %s CASCADE;\n";
    private static final String CREATE_DATABASE = "";
    private static final String CREATE_USER = "GRANT CONNECT, RESOURCE TO %s IDENTIFIED BY %s;\n";
    private static final String GRANT_PERMISSION = "";

    public JiraDatabaseOracleImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String dropDatabase() {
        return "";
    }

    @Override
    protected String dropUser() {
        return String.format(DROP_USER, this.getDataSource().getUsername());
    }

    @Override
    protected String createDatabase() {
        return "";
    }

    @Override
    protected String createUser() {
        return String.format(CREATE_USER, this.getDataSource().getUsername(), this.getDataSource().getPassword());
    }

    @Override
    protected String grantPermissionForUser() {
        return "";
    }

    @Override
    protected String getDatabaseName(String url) {
        return this.getDataSource().getSchema();
    }

    @Override
    public Xpp3Dom getPluginConfiguration() {
        String sql = this.dropDatabase() + this.dropUser() + this.createDatabase() + this.createUser() + this.grantPermissionForUser();
        Xpp3Dom pluginConfiguration = this.baseConfiguration();
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        return pluginConfiguration;
    }
}

