/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.factory.ArtifactFactory;

public class RefappProductHandler
extends AbstractWebappProductHandler {
    @VisibleForTesting
    static final String ATLASSIAN_BUNDLED_PLUGINS_ZIP = "WEB-INF/classes/atlassian-bundled-plugins.zip";
    @VisibleForTesting
    static final String ATLASSIAN_BUNDLED_PLUGINS_DIR = "WEB-INF/atlassian-bundled-plugins";

    public RefappProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        super(context, goals, new RefappPluginProvider(), artifactFactory);
    }

    @Override
    public String getId() {
        return "refapp";
    }

    @Override
    public int getDefaultHttpPort() {
        return 5990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8445;
    }

    @Override
    protected File getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        return null;
    }

    @Override
    protected List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    @Override
    protected File getBundledPluginPath(Product ctx, File appDir) {
        File bundleDir = new File(appDir, ATLASSIAN_BUNDLED_PLUGINS_DIR);
        if (bundleDir.exists() && bundleDir.isDirectory()) {
            return bundleDir;
        }
        return new File(appDir, ATLASSIAN_BUNDLED_PLUGINS_ZIP);
    }

    protected List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    protected List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    protected Map<String, String> getSystemProperties(Product ctx) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(super.getSystemProperties(ctx));
        properties.put((Object)"refapp.home", (Object)this.getHomeDirectory(ctx).getPath());
        properties.put((Object)"osgi.cache", (Object)(this.getHomeDirectory(ctx).getPath() + "/osgi-cache"));
        properties.put((Object)"bundledplugins.cache", (Object)(this.getHomeDirectory(ctx).getPath() + "/bundled-plugins"));
        properties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        return properties.build();
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.refapp", "atlassian-refapp", VersionUtils.getVersion());
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return null;
    }

    private static class RefappPluginProvider
    extends AbstractPluginProvider {
        private RefappPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-appproperties-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-component-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-executor-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-lifecycle-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-message-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-net-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-pluginsettings-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-project-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-search-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-transaction-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-upgrade-plugin", salVersion), new ProductArtifact("com.atlassian.sal", "sal-refimpl-user-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            return Collections.emptyList();
        }
    }
}

