/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.minifier;

import com.atlassian.maven.plugins.amps.util.minifier.GoogleClosureJSMinifier;
import com.atlassian.maven.plugins.amps.util.minifier.YUIErrorReporter;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.mozilla.javascript.ErrorReporter;

public class ResourcesMinifier {
    private static ResourcesMinifier INSTANCE;

    private ResourcesMinifier() {
    }

    public static void minify(List<Resource> resources, File outputDir, boolean useClosureForJs, Log log) {
        if (null == INSTANCE) {
            INSTANCE = new ResourcesMinifier();
        }
        for (Resource resource : resources) {
            INSTANCE.processResource(resource, outputDir, useClosureForJs, log);
        }
    }

    public void processResource(Resource resource, File outputDir, boolean useClosureForJs, Log log) {
        File resourceDir;
        File destDir = outputDir;
        if (StringUtils.isNotBlank((String)resource.getTargetPath())) {
            destDir = new File(outputDir, resource.getTargetPath());
        }
        if (null == (resourceDir = new File(resource.getDirectory())) || !resourceDir.exists()) {
            return;
        }
        this.processJs(resourceDir, destDir, resource.getExcludes(), useClosureForJs, log);
        this.processCss(resourceDir, destDir, resource.getExcludes());
    }

    public void processJs(File resourceDir, File destDir, List<String> excludes, boolean useClosure, Log log) {
        if (useClosure) {
            log.info((CharSequence)"Compiling javascript using Closure");
        } else {
            log.info((CharSequence)"Compiling javascript using YUI");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        scanner.setIncludes(new String[]{"**/*.js"});
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(resourceDir, name);
            String baseName = FilenameUtils.removeExtension((String)name);
            File destFile = new File(destDir, baseName + "-min.js");
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            if (useClosure) {
                this.closureJsCompile(sourceFile, destFile);
                continue;
            }
            this.yuiJsCompile(sourceFile, destFile, log);
        }
    }

    public void processCss(File resourceDir, File destDir, List<String> excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resourceDir);
        scanner.setIncludes(new String[]{"**/*.css"});
        if (null != excludes && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        for (String name : scanner.getIncludedFiles()) {
            File sourceFile = new File(destDir, name);
            String baseName = FilenameUtils.removeExtension((String)name);
            File destFile = new File(destDir, baseName + "-min.css");
            if (!sourceFile.exists() || !sourceFile.canRead()) continue;
            this.yuiCssCompile(sourceFile, destFile);
        }
    }

    private void closureJsCompile(File sourceFile, File destFile) {
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            String source = FileUtils.readFileToString((File)sourceFile);
            String min = GoogleClosureJSMinifier.compile(source);
            FileUtils.writeStringToFile((File)destFile, (String)min);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void yuiJsCompile(File sourceFile, File destFile, Log log) {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            in = new InputStreamReader(new FileInputStream(sourceFile));
            out = new OutputStreamWriter(new FileOutputStream(destFile));
            JavaScriptCompressor yui = new JavaScriptCompressor((Reader)in, (ErrorReporter)new YUIErrorReporter(log));
            yui.compress((Writer)out, -1, true, false, false, false);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void yuiCssCompile(File sourceFile, File destFile) {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            FileUtils.forceMkdir((File)destFile.getParentFile());
            in = new InputStreamReader(new FileInputStream(sourceFile));
            out = new OutputStreamWriter(new FileOutputStream(destFile));
            CssCompressor yui = new CssCompressor((Reader)in);
            yui.compress((Writer)out, -1);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        IOUtils.closeQuietly((Writer)out);
    }
}

