/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.fugue.Pair;
import com.atlassian.maven.plugins.amps.util.AmpsPluginVersionChecker;
import com.atlassian.maven.plugins.amps.util.NOOPProjectRewriter;
import com.atlassian.plugins.codegen.AmpsVersionUpdate;
import com.atlassian.plugins.codegen.MavenProjectRewriter;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ProjectRewriter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import jline.ANSIBuffer;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.dom4j.DocumentException;

public class AmpsPluginVersionCheckerImpl
extends AbstractLogEnabled
implements AmpsPluginVersionChecker {
    public static final List<String> YN_ANSWERS = new ArrayList<String>(Arrays.asList("Y", "y", "N", "n"));
    public static final String NO_VERSION_DEFINED = "no-version-defined";
    public static final String POM_UPDATE_PREF_PREFIX = "sdk-pom-update-check";
    private boolean useAnsiColor;
    private Prompter prompter;
    private boolean skipCheck = false;

    public AmpsPluginVersionCheckerImpl() {
        String mavencolor = System.getenv("MAVEN_COLOR");
        this.useAnsiColor = mavencolor != null && !mavencolor.equals("") ? Boolean.parseBoolean(mavencolor) : false;
    }

    @Override
    public void checkAmpsVersionInPom(String currentVersion, MavenProject project) {
        if (this.skipCheck || null == project.getFile() || !project.getFile().exists()) {
            return;
        }
        String prefKey = "sdk-pom-update-check-" + currentVersion + "-" + DigestUtils.md5Hex((String)project.getArtifactId());
        Preferences prefs = Preferences.userNodeForPackage(AmpsPluginVersionCheckerImpl.class);
        String alreadyRan = prefs.get(prefKey, null);
        if (null != alreadyRan) {
            return;
        }
        prefs.put(prefKey, "true");
        try {
            boolean doUpdate;
            DefaultArtifactVersion runningVersion = new DefaultArtifactVersion(currentVersion);
            Pair<Pair<DefaultArtifactVersion, PomVersionElement>, ProjectRewriter> versionInfo = this.getVersionAndRewriter(project);
            DefaultArtifactVersion versionInPom = (DefaultArtifactVersion)((Pair)versionInfo.left()).left();
            PomVersionElement pomElement = (PomVersionElement)((Pair)versionInfo.left()).right();
            String pomElementType = pomElement.getType();
            String versionProp = pomElement.getVersionProperty();
            ProjectRewriter rewriter = (ProjectRewriter)versionInfo.right();
            boolean managementNeedsUpdate = false;
            boolean pluginNeedsUpdate = false;
            if (pomElementType.equals("management") && (NO_VERSION_DEFINED.equalsIgnoreCase(versionInPom.toString()) || runningVersion.compareTo((Object)versionInPom) > 0)) {
                managementNeedsUpdate = true;
            }
            if (pomElementType.equals("plugin") && (NO_VERSION_DEFINED.equalsIgnoreCase(versionInPom.toString()) || runningVersion.compareTo((Object)versionInPom) > 0)) {
                pluginNeedsUpdate = true;
            }
            if ((pluginNeedsUpdate || managementNeedsUpdate) && (doUpdate = this.promptToUpdatePom(versionInPom, runningVersion))) {
                PluginProjectChangeset changes = new PluginProjectChangeset();
                if (pluginNeedsUpdate) {
                    changes = changes.with(new PluginProjectChange[]{AmpsVersionUpdate.ampsVersionUpdate((String)currentVersion, (String)"plugin", (boolean)true, (boolean)false)});
                }
                if (managementNeedsUpdate) {
                    changes = changes.with(new PluginProjectChange[]{AmpsVersionUpdate.ampsVersionUpdate((String)currentVersion, (String)"management", (boolean)true, (boolean)false)});
                }
                rewriter.applyChanges(changes);
                PluginProjectChangeset propChanges = new PluginProjectChangeset();
                propChanges = propChanges.with(new PluginProjectChange[]{AmpsVersionUpdate.ampsVersionUpdate((String)currentVersion, (String)"plugin", (boolean)false, (boolean)true)});
                ProjectRewriter propRewriter = StringUtils.isNotBlank((String)versionProp) ? this.getRewriterForVersionProp(versionProp, project) : rewriter;
                propRewriter.applyChanges(propChanges);
                this.getLogger().info("AMPS version in pom updated to " + currentVersion);
            }
        }
        catch (Throwable t) {
            this.getLogger().error("unable to check amps version in pom...", t);
        }
    }

    private Pair<Pair<DefaultArtifactVersion, PomVersionElement>, ProjectRewriter> getVersionAndRewriter(MavenProject project) throws IOException, DocumentException {
        DefaultArtifactVersion ampsVersionInPom;
        MavenProjectRewriter rewriter;
        if (null == project.getFile() || !project.getFile().exists()) {
            NOOPProjectRewriter rewriter2 = new NOOPProjectRewriter();
            return Pair.pair((Object)Pair.pair((Object)new DefaultArtifactVersion(NO_VERSION_DEFINED), (Object)new PomVersionElement("management", null)), (Object)rewriter2);
        }
        MavenProjectRewriter mavenRewriter = rewriter = new MavenProjectRewriter(project.getFile());
        String managementVersionInPom = mavenRewriter.getAmpsPluginManagementVersionInPom();
        String pluginVersionInPom = "";
        DefaultArtifactVersion ampsManagementVersionInPom = this.getPomVersion(managementVersionInPom, project);
        try {
            pluginVersionInPom = mavenRewriter.getAmpsVersionInPom();
            ampsVersionInPom = this.getPomVersion(pluginVersionInPom, project);
        }
        catch (IllegalStateException e) {
            ampsVersionInPom = new DefaultArtifactVersion(NO_VERSION_DEFINED);
        }
        String versionProp = "";
        if (managementVersionInPom.startsWith("$")) {
            versionProp = managementVersionInPom;
        }
        if (pluginVersionInPom.startsWith("$")) {
            versionProp = pluginVersionInPom;
        }
        if (project.hasParent() && NO_VERSION_DEFINED.equalsIgnoreCase(ampsManagementVersionInPom.toString()) && NO_VERSION_DEFINED.equalsIgnoreCase(ampsVersionInPom.toString())) {
            return this.getVersionAndRewriter(project.getParent());
        }
        if (!NO_VERSION_DEFINED.equalsIgnoreCase(ampsManagementVersionInPom.toString())) {
            return Pair.pair((Object)Pair.pair((Object)ampsManagementVersionInPom, (Object)new PomVersionElement("management", versionProp)), (Object)rewriter);
        }
        return Pair.pair((Object)Pair.pair((Object)ampsVersionInPom, (Object)new PomVersionElement("plugin", versionProp)), (Object)rewriter);
    }

    private ProjectRewriter getRewriterForVersionProp(String versionProp, MavenProject project) throws IOException, DocumentException {
        if (null == project.getFile() || !project.getFile().exists()) {
            return null;
        }
        MavenProjectRewriter rewriter = new MavenProjectRewriter(project.getFile());
        String propName = StringUtils.substringBetween((String)versionProp, (String)"${", (String)"}");
        if (StringUtils.isNotBlank((String)propName) && rewriter.definesProperty(propName)) {
            return rewriter;
        }
        if (project.hasParent()) {
            return this.getRewriterForVersionProp(versionProp, project.getParent());
        }
        return null;
    }

    @Override
    public void skipPomCheck(boolean skip) {
        this.skipCheck = skip;
    }

    private boolean promptToUpdatePom(DefaultArtifactVersion ampsVersionInPom, DefaultArtifactVersion runningVersion) throws PrompterException {
        if (this.useAnsiColor) {
            return this.promptForUpdateAnsi(ampsVersionInPom, runningVersion);
        }
        return this.promptForUpdatePlain(ampsVersionInPom, runningVersion);
    }

    private boolean promptForUpdateAnsi(DefaultArtifactVersion ampsVersionInPom, DefaultArtifactVersion runningVersion) throws PrompterException {
        ANSIBuffer ansiBuffer = new ANSIBuffer();
        ansiBuffer.append(ANSIBuffer.ANSICodes.attrib((int)33)).append("You are running SDK version ").append(runningVersion.toString()).append(" but your pom is using version ").append(ampsVersionInPom.toString()).append("\n").append(ANSIBuffer.ANSICodes.attrib((int)0)).append(ANSIBuffer.ANSICodes.attrib((int)1)).append("Would you like to have your pom updated?").append(ANSIBuffer.ANSICodes.attrib((int)0));
        return this.promptForBoolean(ansiBuffer.toString(), "Y");
    }

    private boolean promptForUpdatePlain(DefaultArtifactVersion ampsVersionInPom, DefaultArtifactVersion runningVersion) throws PrompterException {
        StringBuilder builder = new StringBuilder();
        builder.append("You are running SDK version ").append(runningVersion.toString()).append(" but your pom is using version ").append(ampsVersionInPom.toString()).append("\n").append("Would you like to have your pom updated?");
        return this.promptForBoolean(builder.toString(), "Y");
    }

    private DefaultArtifactVersion getPomVersion(String ampsVersionOrProperty, MavenProject project) {
        DefaultArtifactVersion ampsVersionInPom = null;
        if (StringUtils.isNotBlank((String)ampsVersionOrProperty) && ampsVersionOrProperty.startsWith("$")) {
            String propName = StringUtils.substringBetween((String)ampsVersionOrProperty, (String)"${", (String)"}");
            if (StringUtils.isNotBlank((String)propName)) {
                ampsVersionInPom = new DefaultArtifactVersion(project.getProperties().getProperty(propName, "0.0"));
            }
        } else {
            ampsVersionInPom = StringUtils.isNotBlank((String)ampsVersionOrProperty) ? new DefaultArtifactVersion(ampsVersionOrProperty) : new DefaultArtifactVersion(NO_VERSION_DEFINED);
        }
        return ampsVersionInPom;
    }

    private boolean promptForBoolean(String message, String defaultValue) throws PrompterException {
        String answer = StringUtils.isBlank((String)defaultValue) ? this.prompter.prompt(message, YN_ANSWERS) : this.prompter.prompt(message, YN_ANSWERS, defaultValue);
        boolean bool = "y".equals(answer.toLowerCase());
        return bool;
    }

    public class PomVersionElement {
        public static final String PLUGIN = "plugin";
        public static final String MANAGEMENT = "management";
        private final String type;
        private final String versionProperty;

        private PomVersionElement(String type, String versionProperty) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.versionProperty = versionProperty;
        }

        public String getType() {
            return this.type;
        }

        public String getVersionProperty() {
            return this.versionProperty;
        }
    }
}

