/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.studio;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.BambooProductHandler;
import com.atlassian.maven.plugins.amps.product.studio.StudioProductHandler;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class StudioBambooProductHandler
extends BambooProductHandler {
    public StudioBambooProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals);
    }

    @Override
    public String getId() {
        return "studio-bamboo";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.studio", "studio-bamboo", "RELEASE");
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(ctx, homeDir);
        StudioProductHandler.processProductsHomeDirectory(this.log, ctx, homeDir);
    }

    @Override
    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        StudioProductHandler.addProductHandlerOverrides(this.log, ctx, homeDir, explodedWarDir);
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Arrays.asList(new ProductArtifact("hsqldb", "hsqldb", "1.8.0.5"), new ProductArtifact("jta", "jta", "1.0.1"));
    }

    @Override
    public Map<String, String> getSystemProperties(Product product) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(super.getSystemProperties(product));
        systemProperties.putAll(product.getStudioProperties().getSystemProperties());
        return systemProperties;
    }

    @Override
    protected DataSource getDefaultDataSource(Product ctx) {
        DataSource dataSource = new DataSource();
        dataSource.setJndi("jdbc/DefaultDS");
        dataSource.setUrl(String.format("jdbc:hsqldb:%s/database", FileUtils.fixWindowsSlashes(this.getHomeDirectory(ctx).getAbsolutePath())));
        dataSource.setDriver("org.hsqldb.jdbcDriver");
        dataSource.setType("javax.sql.DataSource");
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        return dataSource;
    }
}

