/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class JiraProductHandler
extends AbstractWebappProductHandler {
    public JiraProductHandler(MavenContext context, MavenGoals goals) {
        super(context, goals, new JiraPluginProvider());
    }

    @Override
    public String getId() {
        return "jira";
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.jira", "atlassian-jira-webapp", "RELEASE");
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.jira.plugins", "jira-plugin-test-resources");
    }

    @Override
    public int getDefaultHttpPort() {
        return 2990;
    }

    protected static File getHsqlDatabaseFile(File homeDirectory) {
        return new File(homeDirectory, "database");
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(super.getSystemProperties(ctx));
        properties.put((Object)"jira.home", (Object)FileUtils.fixWindowsSlashes(this.getHomeDirectory(ctx).getPath()));
        properties.put((Object)"catalina.servlet.uriencoding", (Object)"UTF-8");
        return properties.build();
    }

    @Override
    protected DataSource getDefaultDataSource(Product ctx) {
        DataSource dataSource = new DataSource();
        dataSource.setJndi("jdbc/JiraDS");
        dataSource.setUrl(String.format("jdbc:hsqldb:%s/database", FileUtils.fixWindowsSlashes(this.getHomeDirectory(ctx).getAbsolutePath())));
        dataSource.setDriver("org.hsqldb.jdbcDriver");
        dataSource.setType("javax.sql.DataSource");
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    @Override
    public File getUserInstalledPluginsDirectory(File webappDir, File homeDir) {
        return new File(new File(homeDir, "plugins"), "installed-plugins");
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Arrays.asList(new ProductArtifact("hsqldb", "hsqldb", "1.8.0.5"), new ProductArtifact("jta", "jta", "1.0.1"), new ProductArtifact("ots-jts", "ots-jts", "1.0"), new ProductArtifact("jotm", "jotm", "1.4.3"), new ProductArtifact("jotm", "jotm-jrmp_stubs", "1.4.3"), new ProductArtifact("jotm", "jotm-iiop_stubs", "1.4.3"), new ProductArtifact("jotm", "jonas_timer", "1.4.3"), new ProductArtifact("jotm", "objectweb-datasource", "1.4.3"), new ProductArtifact("carol", "carol", "1.5.2"), new ProductArtifact("carol", "carol-properties", "1.0"), new ProductArtifact("xapool", "xapool", "1.3.1"), new ProductArtifact("commons-logging", "commons-logging", "1.1.1"));
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        String bundledPluginPluginsPath = "WEB-INF/classes/atlassian-bundled-plugins.zip";
        String[] version = ctx.getVersion().split("-", 2)[0].split("\\.");
        try {
            long minor;
            long major = Long.parseLong(version[0]);
            long l = minor = version.length > 1 ? Long.parseLong(version[1]) : 0L;
            if (major < 4L || major == 4L && minor == 0L) {
                bundledPluginPluginsPath = "WEB-INF/classes/com/atlassian/jira/plugin/atlassian-bundled-plugins.zip";
            }
        }
        catch (NumberFormatException e) {
            this.log.debug((CharSequence)String.format("Unable to parse JIRA version '%s', assuming JIRA 4.1 or newer.", ctx.getVersion()), (Throwable)e);
        }
        return new File(appDir, bundledPluginPluginsPath);
    }

    @Override
    public void processHomeDirectory(Product ctx, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(ctx, homeDir);
        JiraProductHandler.createDbConfigXmlIfNecessary(homeDir);
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        String contextPath = ctx.getContextPath();
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        String baseUrl = "http://" + ctx.getServer() + ":" + ctx.getHttpPort() + contextPath;
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        File homeDir = this.getHomeDirectory(ctx);
        replacements.add(0, new ConfigFileUtils.Replacement("http://localhost:8080", baseUrl, false));
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", homeDir.getParent(), false));
        replacements.add(new ConfigFileUtils.Replacement("/jira-home/", "/home/", false));
        replacements.add(new ConfigFileUtils.Replacement("@base-url@", baseUrl, false));
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDir) {
        List<File> configFiles = super.getConfigFiles(product, homeDir);
        configFiles.add(new File(homeDir, "database.log"));
        configFiles.add(new File(homeDir, "database.script"));
        configFiles.add(new File(homeDir, "dbconfig.xml"));
        return configFiles;
    }

    static void createDbConfigXmlIfNecessary(File homeDir) throws MojoExecutionException {
        File dbConfigXml = new File(homeDir, "dbconfig.xml");
        if (dbConfigXml.exists()) {
            return;
        }
        InputStream templateIn = JiraProductHandler.class.getResourceAsStream("jira-dbconfig-template.xml");
        if (templateIn == null) {
            throw new MojoExecutionException("Missing internal resource: jira-dbconfig-template.xml");
        }
        try {
            String template = IOUtils.toString((InputStream)templateIn, (String)"utf-8");
            File dbFile = JiraProductHandler.getHsqlDatabaseFile(homeDir);
            String jdbcUrl = "jdbc:hsqldb:file:" + dbFile.toURI().getPath();
            String result = template.replace("@jdbc-url@", jdbcUrl);
            org.apache.commons.io.FileUtils.writeStringToFile((File)dbConfigXml, (String)result, (String)"utf-8");
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to create dbconfig.xml", (Exception)ioe);
        }
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(snapshotDir, "log/atlassian-jira.log"));
    }

    private static class JiraPluginProvider
    extends AbstractPluginProvider {
        private JiraPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-jira-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            ArrayList<ProductArtifact> plugins = new ArrayList<ProductArtifact>();
            plugins.addAll(super.getPdkInstallArtifacts(pdkInstallVersion));
            plugins.add(new ProductArtifact("commons-fileupload", "commons-fileupload", "1.2.1"));
            return plugins;
        }
    }
}

