/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.fugue.Option;
import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.util.ClassUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.ComponentDeclaration;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.PluginXmlRewriter;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.dom4j.DocumentException;
import org.junit.Test;

@Mojo(name="test-jar", requiresDependencyResolution=ResolutionScope.TEST)
public class TestJarMojo
extends AbstractAmpsMojo {
    @Parameter(property="project.build.finalName")
    private String finalName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject prj = this.getMavenContext().getProject();
        File testClassesDir = FileUtils.file(prj.getBuild().getTestOutputDirectory(), new String[0]);
        if (this.shouldBuildTestPlugin()) {
            File mf = FileUtils.file(testClassesDir, "META-INF", "MANIFEST.MF");
            if (!mf.exists()) {
                try {
                    String symbolicName = prj.getGroupId() + "." + prj.getArtifactId() + "-tests";
                    org.apache.commons.io.FileUtils.writeStringToFile((File)mf, (String)("Manifest-Version: 1.0\nBundle-SymbolicName: " + symbolicName + "\n" + "Bundle-Version: 1.0\n" + "Bundle-Name: " + this.finalName + "-tests\n" + "DynamicImport-Package: *\n" + "Atlassian-Plugin-Key: " + symbolicName + "\n"));
                }
                catch (IOException e) {
                    throw new MojoFailureException("Unable to write manifest");
                }
            }
            File pluginXml = FileUtils.file(testClassesDir, "atlassian-plugin.xml");
            File itPackageDir = FileUtils.file(testClassesDir, "it");
            if (pluginXml.exists() && itPackageDir.exists()) {
                PluginProjectChangeset changes = new PluginProjectChangeset();
                Collection classFiles = org.apache.commons.io.FileUtils.listFiles((File)itPackageDir, (String[])new String[]{"class"}, (boolean)true);
                try {
                    for (File classFile : classFiles) {
                        String className = ClassUtils.getClassnameFromFile(classFile, prj.getBuild().getTestOutputDirectory());
                        if (!ClassUtils.isWiredPluginTestClass(classFile)) continue;
                        this.getLog().info((CharSequence)("found Test: " + className + ", adding to plugin.xml..."));
                        HashMap<String, String> serviceProps = new HashMap<String, String>();
                        serviceProps.put("inProductTest", "true");
                        String simpleClassname = StringUtils.substringAfterLast((String)className, (String)".");
                        ComponentDeclaration component = ComponentDeclaration.builder((ClassId)ClassId.fullyQualified((String)className), (String)ClassnameUtil.camelCaseToDashed((String)simpleClassname).toLowerCase()).interfaceId(Option.some((Object)ClassId.fullyQualified((String)className))).visibility(ComponentDeclaration.Visibility.PUBLIC).serviceProperties(serviceProps).build();
                        changes = changes.with(new PluginProjectChange[]{component});
                    }
                    new PluginXmlRewriter(pluginXml).applyChanges(changes);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("unable to convert test classes folder to URL", (Exception)e);
                }
                catch (DocumentException e) {
                    throw new MojoExecutionException("unable to modify plugin.xml", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("unable to modify plugin.xml", (Exception)e);
                }
            }
            this.getMavenGoals().jarTests(this.finalName);
        }
    }

    private boolean hasTestMethod(Class<?> testClass) {
        Method[] methods;
        boolean hasTestAnno = false;
        for (Method m : methods = testClass.getMethods()) {
            if (!m.isAnnotationPresent(Test.class)) continue;
            hasTestAnno = true;
            break;
        }
        return hasTestAnno;
    }
}

