/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.RunMojo;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jfrog.maven.annomojo.annotations.MojoExecute;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="debug")
@MojoExecute(phase="package")
@MojoRequiresDependencyResolution
public class DebugMojo
extends RunMojo {
    @MojoParameter(expression="${jvm.debug.port}", defaultValue="5005")
    protected int jvmDebugPort;
    @MojoParameter(expression="${jvm.debug.suspend}")
    protected boolean jvmDebugSuspend = false;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getGoogleTracker().track("Debug");
        List<ProductExecution> productExecutions = this.getProductExecutions();
        this.setParallelMode(productExecutions);
        int counter = 0;
        for (ProductExecution productExecution : productExecutions) {
            Product product = productExecution.getProduct();
            if (product.getJvmDebugPort() == 0) {
                product.setJvmDebugPort(this.jvmDebugPort + counter++);
            }
            int port = product.getJvmDebugPort();
            String debugArgs = " -Xdebug -Xrunjdwp:transport=dt_socket,address=" + String.valueOf(port) + ",suspend=" + (this.jvmDebugSuspend ? "y" : "n") + ",server=y ";
            if (product.getJvmArgs() == null) {
                product.setJvmArgs(StringUtils.defaultString((String)this.jvmArgs));
            }
            product.setJvmArgs(product.getJvmArgs() + debugArgs);
            if (this.writePropertiesToFile) {
                if (productExecutions.size() == 1) {
                    this.properties.put("debug.port", String.valueOf(port));
                }
                this.properties.put("debug." + product.getInstanceId() + ".port", String.valueOf(port));
            }
            if (!"fecru".equals(this.getDefaultProductId()) || !this.debugNotSet()) continue;
            String message = "You must set the ATLAS_OPTS environment variable to the following string:'" + product.getJvmArgs() + "' when calling atlas-debug to enable Fisheye/Crucible debugging.";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        this.startProducts(productExecutions);
    }

    private boolean debugNotSet() {
        String atlasOpts = System.getenv("ATLAS_OPTS");
        return atlasOpts == null || !atlasOpts.contains("-Xdebug");
    }
}

