/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductAwareMojo;
import com.atlassian.maven.plugins.amps.codegen.ConditionFactory;
import com.atlassian.maven.plugins.amps.codegen.ContextProviderFactory;
import com.atlassian.maven.plugins.amps.codegen.PluginModuleSelectionQueryer;
import com.atlassian.maven.plugins.amps.codegen.jira.ActionTypeFactory;
import com.atlassian.maven.plugins.amps.codegen.jira.CustomFieldSearcherFactory;
import com.atlassian.maven.plugins.amps.codegen.jira.CustomFieldTypeFactory;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompter;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompterFactory;
import com.atlassian.plugins.codegen.annotations.DependencyDescriptor;
import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleCreatorFactory;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.PluginModuleProperties;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.XmlStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.shade.pom.PomWriter;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoRequiresDependencyResolution(value="compile")
@MojoGoal(value="create-plugin-module")
public class PluginModuleGenerationMojo
extends AbstractProductAwareMojo {
    @MojoComponent
    private PluginModuleSelectionQueryer pluginModuleSelectionQueryer;
    @MojoComponent
    private PluginModulePrompterFactory pluginModulePrompterFactory;
    @MojoComponent
    private PluginModuleCreatorFactory pluginModuleCreatorFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.pluginModulePrompterFactory.setLog(this.getLog());
        try {
            this.pluginModulePrompterFactory.scanForPrompters();
        }
        catch (Exception e) {
            String message = "Error initializing Plugin Module Prompters";
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
        String productId = this.getProductId();
        MavenProject project = this.getMavenContext().getProject();
        File javaDir = this.getJavaSourceRoot(project);
        File testDir = this.getJavaTestRoot(project);
        File resourcesDir = this.getResourcesRoot(project);
        this.initHelperFactories(productId, project);
        PluginModuleLocation moduleLocation = new PluginModuleLocation.Builder(javaDir).resourcesDirectory(resourcesDir).testDirectory(testDir).templateDirectory(new File(resourcesDir, "templates")).build();
        if (!moduleLocation.getPluginXml().exists()) {
            String message = "Couldn't find the atlassian-plugin.xml, please run this goal in an atlassian plugin project root.";
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
        this.runGeneration(productId, project, moduleLocation);
    }

    private void runGeneration(String productId, MavenProject project, PluginModuleLocation moduleLocation) throws MojoExecutionException {
        PluginModuleCreator creator = null;
        try {
            creator = this.pluginModuleSelectionQueryer.selectModule(this.pluginModuleCreatorFactory.getModuleCreatorsForProduct(productId));
            String trackingLabel = this.getPluginInformation().getId() + ":" + creator.getModuleName();
            this.getGoogleTracker().track("Create Plugin Module", trackingLabel);
            PluginModulePrompter modulePrompter = this.pluginModulePrompterFactory.getPrompterForCreatorClass(creator.getClass());
            if (modulePrompter == null) {
                String message = "Couldn't find an input prompter for: " + creator.getClass().getName();
                this.getLog().error((CharSequence)message);
                throw new MojoExecutionException(message);
            }
            modulePrompter.setDefaultBasePackage(project.getGroupId());
            PluginModuleProperties moduleProps = modulePrompter.getModulePropertiesFromInput(moduleLocation);
            moduleProps.setProductId(this.getGadgetCompatibleProductId(productId));
            creator.createModule(moduleLocation, moduleProps);
            this.addRequiredModuleDependenciesToPOM(project, creator);
            if (this.pluginModuleSelectionQueryer.addAnotherModule()) {
                this.runGeneration(productId, project, moduleLocation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error creating plugin module", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequiredModuleDependenciesToPOM(MavenProject project, PluginModuleCreator creator) {
        List descriptors = this.pluginModuleCreatorFactory.getDependenciesForCreatorClass(creator.getClass());
        boolean modifyPom = false;
        if (descriptors != null && !descriptors.isEmpty()) {
            List originalDependencies = project.getModel().getDependencies();
            for (DependencyDescriptor descriptor : descriptors) {
                Dependency alreadyExisting = (Dependency)CollectionUtils.find((Collection)originalDependencies, (Predicate)new DependencyPredicate(descriptor));
                if (null != alreadyExisting) continue;
                modifyPom = true;
                Dependency newDependency = new Dependency();
                newDependency.setGroupId(descriptor.getGroupId());
                newDependency.setArtifactId(descriptor.getArtifactId());
                newDependency.setVersion(descriptor.getVersion());
                newDependency.setScope(descriptor.getScope());
                project.getOriginalModel().addDependency(newDependency);
            }
        }
        if (modifyPom) {
            File pom = project.getFile();
            XmlStreamWriter writer = null;
            try {
                writer = new XmlStreamWriter(pom);
                PomWriter.write((Writer)writer, project.getOriginalModel(), true);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to write plugin-module dependencies to pom.xml", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    IOUtils.closeQuietly((Writer)writer);
                }
            }
        }
    }

    private String getGadgetCompatibleProductId(String pid) {
        String productId = pid;
        productId = "jira".equals(pid) ? "JIRA" : ("confluence".equals(pid) ? "Confluence" : ("bamboo".equals(pid) ? "Bamboo" : ("crowd".equals(pid) ? "Crowd" : ("fecru".equals(pid) ? "FishEye" : "Other"))));
        return productId;
    }

    private File getJavaSourceRoot(MavenProject project) {
        return new File(project.getModel().getBuild().getSourceDirectory());
    }

    private File getJavaTestRoot(MavenProject project) {
        return new File(project.getModel().getBuild().getTestSourceDirectory());
    }

    private File getResourcesRoot(MavenProject project) {
        File resourcesRoot = null;
        for (Resource resource : project.getModel().getBuild().getResources()) {
            String pathToCheck = "src" + File.separator + "main" + File.separator + "resources";
            if (!StringUtils.endsWith((String)resource.getDirectory(), (String)pathToCheck)) continue;
            resourcesRoot = new File(resource.getDirectory());
        }
        return resourcesRoot;
    }

    private void initHelperFactories(String productId, MavenProject project) throws MojoExecutionException {
        String message;
        List pluginClasspath;
        try {
            pluginClasspath = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependencies MUST be resolved", (Exception)((Object)e));
        }
        try {
            ConditionFactory.locateAvailableConditions((String)productId, (List)pluginClasspath);
        }
        catch (Exception e) {
            message = "Error initializing Plugin Module Conditions";
            this.getLog().error((CharSequence)message);
        }
        try {
            ContextProviderFactory.locateAvailableContextProviders((String)productId, (List)pluginClasspath);
        }
        catch (Exception e) {
            message = "Error initializing Plugin Module Context Providers";
            this.getLog().error((CharSequence)message);
        }
        if ("jira".equals(productId)) {
            try {
                ActionTypeFactory.locateAvailableActionTypes((List)pluginClasspath);
            }
            catch (Exception e) {
                message = "Error initializing JIRA Action Types";
                this.getLog().error((CharSequence)message);
            }
            try {
                CustomFieldTypeFactory.locateAvailableCustomFieldTypes((List)pluginClasspath);
            }
            catch (Exception e) {
                message = "Error initializing JIRA Custom Field Types";
                this.getLog().error((CharSequence)message);
            }
            try {
                CustomFieldSearcherFactory.locateAvailableCustomFieldSearchers((List)pluginClasspath);
            }
            catch (Exception e) {
                message = "Error initializing JIRA Custom Field Searchers";
                this.getLog().error((CharSequence)message);
            }
        }
    }

    private class DependencyPredicate
    implements Predicate {
        private DependencyDescriptor depToCheck;

        private DependencyPredicate(DependencyDescriptor depToCheck) {
            this.depToCheck = depToCheck;
        }

        public boolean evaluate(Object o) {
            Dependency d = (Dependency)o;
            return this.depToCheck.getGroupId().equals(d.getGroupId()) && this.depToCheck.getArtifactId().equals(d.getArtifactId());
        }
    }
}

