/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenContext {
    private final MavenProject project;
    private final List<MavenProject> reactor;
    private final MavenSession session;
    private final PluginManager pluginManager;
    private final BuildPluginManager buildPluginManager;
    private final Log log;

    public MavenContext(MavenProject project, List<MavenProject> reactor, MavenSession session, PluginManager pluginManager, Log log) {
        this(project, reactor, session, pluginManager, null, log);
    }

    public MavenContext(MavenProject project, List<MavenProject> reactor, MavenSession session, BuildPluginManager buildPluginManager, Log log) {
        this(project, reactor, session, null, buildPluginManager, log);
    }

    private MavenContext(MavenProject project, List<MavenProject> reactor, MavenSession session, PluginManager pluginManager, BuildPluginManager buildPluginManager, Log log) {
        this.project = project;
        this.reactor = reactor;
        this.session = session;
        this.pluginManager = pluginManager;
        this.buildPluginManager = buildPluginManager;
        this.log = log;
    }

    public MavenProject getProject() {
        return this.project;
    }

    MavenSession getSession() {
        return this.session;
    }

    public Log getLog() {
        return this.log;
    }

    public List<MavenProject> getReactor() {
        return this.reactor;
    }

    public MavenContext with(MavenProject project, List<MavenProject> reactor, MavenSession session) {
        return new MavenContext(project, reactor, session, this.pluginManager, this.buildPluginManager, this.log);
    }

    public MojoExecutor.ExecutionEnvironment getExecutionEnvironment() {
        if (this.buildPluginManager != null) {
            return MojoExecutor.executionEnvironment(this.project, this.session, this.buildPluginManager);
        }
        return MojoExecutor.executionEnvironment(this.project, this.session, this.pluginManager);
    }
}

