/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import java.io.File;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="integration-test")
@MojoRequiresDependencyResolution(value="test")
public class IntegrationTestMojo
extends AbstractProductHandlerMojo {
    @MojoParameter(expression="${functional.test.pattern}")
    private final String functionalTestPattern = "it/**";
    @MojoParameter(expression="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;
    @MojoParameter(expression="${no.webapp}", defaultValue="false")
    private final boolean noWebapp = false;
    @MojoComponent
    private ArtifactHandlerManager artifactHandlerManager;
    @MojoParameter(expression="${maven.test.skip}", defaultValue="false")
    private boolean testsSkip = false;
    @MojoParameter(expression="${skipTests}", defaultValue="false")
    private boolean skipTests = false;

    protected void doExecute() throws MojoExecutionException {
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        this.runTestsForProduct(this.getProductId(), goals, pluginJar);
        for (String productId : ProductHandlerFactory.getIds()) {
            if (!this.containsTests(productId) || productId.equals(this.getProductId())) continue;
            this.runTestsForProduct(productId, goals, pluginJar);
        }
    }

    private void runTestsForProduct(String productId, MavenGoals goals, String pluginJar) throws MojoExecutionException {
        ProductHandler product = ProductHandlerFactory.create(productId, this.getMavenContext().getProject(), goals);
        Product ctx = this.getProductContexts(goals).get(0);
        ctx.setInstallPlugin(this.installPlugin);
        int actualHttpPort = product.start(ctx);
        goals.runTests(this.getProductId(), this.containerId, "it/**", actualHttpPort, ctx.getContextPath(), pluginJar);
        product.stop(ctx);
    }

    private boolean containsTests(String type) {
        return this.scanFile(new File(this.testClassesDirectory, "it"), type);
    }

    private boolean scanFile(File file, String type) {
        if (file.isDirectory()) {
            if (file.getName().equals(type)) {
                return true;
            }
            for (File kid : file.listFiles()) {
                if (!this.scanFile(kid, type)) continue;
                return true;
            }
        }
        return false;
    }
}

