/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.osgi.OsgiHelper;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

@MojoGoal(value="generate-manifest")
public class GenerateManifestMojo
extends AbstractAmpsMojo {
    @MojoParameter
    private Map instructions = new HashMap();

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = this.getMavenContext().getProject();
        if (!this.instructions.isEmpty() || OsgiHelper.isAtlassianPlugin(project)) {
            File metainfLib;
            this.getLog().info((CharSequence)"Generating a manifest for this plugin");
            if (!this.instructions.containsKey("Export-Package")) {
                this.instructions.put("Export-Package", "");
            }
            if ((metainfLib = FileUtils.file(project.getBuild().getOutputDirectory(), "META-INF", "lib")).exists()) {
                StringBuilder sb = new StringBuilder(".");
                for (File lib : metainfLib.listFiles()) {
                    sb.append(",").append("META-INF/lib/" + lib.getName());
                }
                this.instructions.put("Bundle-ClassPath", sb.toString());
            }
            this.getMavenGoals().generateManifest(this.instructions);
        } else {
            this.getLog().info((CharSequence)"No manifest instructions found, skipping manifest generation");
        }
    }
}

