/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import java.io.File;
import java.util.Properties;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="integration-test")
@MojoRequiresDependencyResolution(value="test")
public class IntegrationTestMojo
extends AbstractProductHandlerMojo {
    @MojoParameter(expression="${functional.test.pattern}")
    private String functionalTestPattern = "it/**";
    @MojoParameter(expression="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;
    @MojoParameter(expression="${no.webapp}", defaultValue="false")
    private boolean noWebapp = false;
    @MojoComponent
    private ArtifactHandlerManager artifactHandlerManager;
    @MojoParameter(expression="${maven.test.skip}", defaultValue="false")
    private boolean testsSkip = false;
    @MojoParameter(expression="${skipTests}", defaultValue="false")
    private boolean skipTests = false;
    @MojoParameter(expression="${maven.test.systemProperties}")
    private Properties systemProperties = new Properties();

    protected void doExecute() throws MojoExecutionException {
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        this.runTestsForProduct(this.getProductId(), goals, pluginJar, this.systemProperties);
        for (String productId : ProductHandlerFactory.getIds()) {
            if (!this.containsTests(productId) || productId.equals(this.getProductId())) continue;
            this.runTestsForProduct(productId, goals, pluginJar, this.systemProperties);
        }
    }

    private void runTestsForProduct(String productId, MavenGoals goals, String pluginJar, Properties systemProperties) throws MojoExecutionException {
        ProductHandler product = ProductHandlerFactory.create(productId, this.getMavenContext().getProject(), goals, this.getLog());
        Product ctx = this.getProductContexts(goals).get(0);
        ctx.setInstallPlugin(this.installPlugin);
        int actualHttpPort = 0;
        if (!this.noWebapp) {
            actualHttpPort = product.start(ctx);
        }
        systemProperties.put("http.port", String.valueOf(actualHttpPort));
        systemProperties.put("context.path", ctx.getContextPath());
        systemProperties.put("plugin.jar", pluginJar);
        goals.runTests(this.getProductId(), this.containerId, this.functionalTestPattern, systemProperties);
        if (!this.noWebapp) {
            product.stop(ctx);
        }
    }

    private boolean containsTests(String type) {
        return this.scanFile(new File(this.testClassesDirectory, "it"), type);
    }

    private boolean scanFile(File file, String type) {
        if (file.isDirectory()) {
            if (file.getName().equals(type)) {
                return true;
            }
            for (File kid : file.listFiles()) {
                if (!this.scanFile(kid, type)) continue;
                return true;
            }
        }
        return false;
    }
}

