/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerAwareMojo;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProductHandlerMojo
extends AbstractProductHandlerAwareMojo {
    @MojoParameter(expression="${container}", defaultValue="tomcat6x")
    protected String containerId;
    @MojoParameter(expression="${http.port}", defaultValue="0")
    private int httpPort;
    @MojoParameter(expression="${context.path}")
    protected String contextPath;
    @MojoParameter(expression="${server}", defaultValue="localhost")
    protected String server;
    @MojoParameter(expression="${product.version}")
    private String productVersion;
    @MojoParameter(expression="${jvmargs}")
    protected String jvmArgs;
    @MojoParameter
    protected File log4jProperties;
    @MojoParameter(expression="${test.resources.version}")
    private String testResourcesVersion;
    @MojoParameter(expression="${product.data.version}", defaultValue="LATEST")
    private String productDataVersion;
    @MojoParameter
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    @MojoParameter(expression="${sal.version}")
    private String salVersion;
    @MojoParameter(expression="${pdk.version}", defaultValue="0.4")
    private String pdkVersion;
    @MojoParameter(expression="${rest.version}")
    private String restVersion;
    @MojoParameter(expression="${web.console.version}", defaultValue="1.2.8")
    private String webConsoleVersion;
    @MojoParameter(expression="${plugins}")
    private String pluginArtifactsString;
    @MojoParameter(expression="${lib.plugins}")
    private String libArtifactsString;
    @MojoParameter(expression="${bundled.plugins}")
    private String bundledArtifactsString;
    @MojoParameter(expression="${project.build.directory}", required=true)
    protected File targetDirectory;
    @MojoParameter(expression="${project.build.finalName}", required=true)
    protected String finalName;
    @MojoParameter(expression="${install.plugin}", defaultValue="true")
    protected boolean installPlugin;
    @MojoComponent
    private ArtifactResolver artifactResolver;
    @MojoParameter(expression="${localRepository}")
    private ArtifactRepository localRepository;
    @MojoParameter(expression="${project.remoteArtifactRepositories}")
    private List repositories;
    @MojoComponent
    private ArtifactFactory artifactFactory;
    @MojoParameter
    private List<Product> products = new ArrayList<Product>();

    private Product createDefaultProductContext() throws MojoExecutionException {
        String dversion = this.testResourcesVersion != null ? this.testResourcesVersion : this.productDataVersion;
        dversion = System.getProperty("product.data.version", dversion);
        String pversion = System.getProperty("product.version", this.productVersion);
        Product ctx = new Product();
        ctx.setId(this.getProductId());
        ctx.setContainerId(this.containerId);
        ctx.setServer(this.server);
        ctx.setContextPath(this.contextPath);
        ctx.setJvmArgs(this.jvmArgs);
        ctx.setBundledArtifacts(this.bundledArtifacts);
        ctx.setLibArtifacts(this.libArtifacts);
        ctx.setPluginArtifacts(this.pluginArtifacts);
        ctx.setLog4jProperties(this.log4jProperties);
        ctx.setProductDataVersion(dversion);
        ctx.setHttpPort(this.httpPort);
        ctx.setArtifactRetriever(new ArtifactRetriever(this.artifactResolver, this.artifactFactory, this.localRepository, this.repositories));
        ctx.setRestVersion(this.restVersion);
        ctx.setSalVersion(this.salVersion);
        ctx.setPdkVersion(this.pdkVersion);
        ctx.setWebConsoleVersion(this.webConsoleVersion);
        ctx.setHttpPort(this.httpPort);
        ctx.setVersion(pversion);
        ctx.setContextPath(this.contextPath);
        return ctx;
    }

    private List<ProductArtifact> stringToArtifactList(String val, List<ProductArtifact> artifacts) {
        if (val == null || val.trim().length() == 0) {
            return artifacts;
        }
        for (String ptn : val.split(",")) {
            String[] items = ptn.split(":");
            if (items.length < 2 || items.length > 3) {
                throw new IllegalArgumentException("Invalid artifact pattern: " + ptn);
            }
            String groupId = items[0];
            String artifactId = items[1];
            String version = items.length == 3 ? items[2] : "LATEST";
            artifacts.add(new ProductArtifact(groupId, artifactId, version));
        }
        return artifacts;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.stringToArtifactList(this.pluginArtifactsString, this.pluginArtifacts);
        this.stringToArtifactList(this.libArtifactsString, this.libArtifacts);
        this.stringToArtifactList(this.bundledArtifactsString, this.bundledArtifacts);
        this.doExecute();
    }

    protected List<Product> getProductContexts(MavenGoals goals) throws MojoExecutionException {
        ArrayList<Product> list = new ArrayList<Product>(this.products);
        if (this.getProductId() != null) {
            list.add(0, this.createDefaultProductContext());
        }
        for (Product ctx : list) {
            ProductHandler handler = ProductHandlerFactory.create(ctx.getId(), this.getMavenContext().getProject(), goals, this.getLog());
            ctx.setHttpPort(ctx.getHttpPort() == 0 ? handler.getDefaultHttpPort() : ctx.getHttpPort());
            ctx.setVersion(ctx.getVersion() == null ? "RELEASE" : ctx.getVersion());
            ctx.setContextPath(ctx.getContextPath() == null ? "/" + handler.getId() : ctx.getContextPath());
        }
        return list;
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}

