/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import aQute.libg.header.OSGiHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageImportVersionValidator {
    private final MavenProject project;
    private final Map<String, Set<String>> jarPackageCache = new HashMap<String, Set<String>>();

    public PackageImportVersionValidator(MavenProject project) {
        this.project = project;
    }

    public void validate(String imports) throws MojoFailureException {
        if (imports != null) {
            HashMap<String, String> unknownPackages = new HashMap<String, String>();
            Map pkgImports = OSGiHeader.parseHeader((String)imports);
            for (Map.Entry pkgImport : pkgImports.entrySet()) {
                String pkg = (String)pkgImport.getKey();
                if (pkgImport.getValue() != null && ((Map)pkgImport.getValue()).size() > 0) {
                    Map props = (Map)pkgImport.getValue();
                    String version = (String)props.get("version");
                    if (version != null && version.length() != 0) continue;
                    unknownPackages.put(pkg, this.guessVersion(pkg));
                    continue;
                }
                unknownPackages.put(pkg, this.guessVersion(pkg));
            }
            if (!unknownPackages.isEmpty()) {
                StringBuilder sb = new StringBuilder("Manifest must contain versions for all imports.  Suggested changes:\n");
                for (Map.Entry<String, String> entry : PackageImportVersionValidator.compressPackages(unknownPackages).entrySet()) {
                    sb.append(entry.getKey()).append(";version=\"").append(entry.getValue()).append("\",\n");
                }
                throw new MojoFailureException(sb.substring(0, sb.length() - 2));
            }
        }
    }

    static Map<String, String> compressPackages(Map<String, String> unknownPackages) {
        HashMap<String, String> pkgs = new HashMap<String, String>();
        TreeSet<String> unmatchedPackages = new TreeSet<String>(unknownPackages.keySet());
        block0: for (String pkg : new TreeSet<String>(unknownPackages.keySet())) {
            if (!unmatchedPackages.contains(pkg)) continue;
            String version = unknownPackages.get(pkg);
            TreeSet<String> others = new TreeSet<String>((Collection<String>)unmatchedPackages);
            others.remove(pkg);
            for (int curpos = 0; curpos < pkg.length(); ++curpos) {
                char curchar = pkg.charAt(curpos);
                boolean sameVersion = true;
                Iterator i = others.iterator();
                while (i.hasNext()) {
                    String other = (String)i.next();
                    if (PackageImportVersionValidator.otherMatchesNextChar(curpos, curchar, other)) {
                        i.remove();
                        continue;
                    }
                    if (unknownPackages.get(other).equals(version)) continue;
                    sameVersion = false;
                    break;
                }
                if (curpos != pkg.length() - 1 && !sameVersion) continue;
                if (others.size() > 0 && sameVersion) {
                    StringBuilder pattern = PackageImportVersionValidator.greedlyBuildPattern(pkg, others, curpos);
                    pkgs.put(pattern + "*", version);
                } else {
                    pkgs.put(pkg, version);
                }
                unmatchedPackages.remove(pkg);
                if (!sameVersion) continue block0;
                unmatchedPackages.removeAll(others);
                continue block0;
            }
        }
        return pkgs;
    }

    private static boolean otherMatchesNextChar(int curpos, char curchar, String other) {
        return other.length() <= curpos || curchar != other.charAt(curpos);
    }

    private static StringBuilder greedlyBuildPattern(String pkg, Set<String> others, int curpos) {
        StringBuilder pattern = new StringBuilder(pkg.substring(0, curpos + 1));
        for (int greedyPos = curpos + 1; greedyPos < pkg.length(); ++greedyPos) {
            boolean canConsumeAnotherChar = true;
            for (String greedyOther : others) {
                if (!PackageImportVersionValidator.otherMatchesNextChar(greedyPos, pkg.charAt(greedyPos), greedyOther)) continue;
                canConsumeAnotherChar = false;
                break;
            }
            if (!canConsumeAnotherChar) continue;
            pattern.append(pkg.charAt(greedyPos));
        }
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String guessVersion(String pkg) {
        for (Artifact artifact : new HashSet(this.project.getArtifacts())) {
            File file = artifact.getFile();
            if (!file.exists() || !file.getName().endsWith(".jar")) continue;
            Set<String> contents = this.jarPackageCache.get(file.getAbsolutePath());
            if (contents == null) {
                contents = new HashSet<String>();
                this.jarPackageCache.put(file.getAbsolutePath(), contents);
                ZipInputStream in = null;
                try {
                    ZipEntry entry;
                    in = new ZipInputStream(new FileInputStream(file));
                    while ((entry = in.getNextEntry()) != null) {
                        contents.add(entry.getName());
                    }
                }
                catch (IOException e) {
                    IOUtils.closeQuietly(in);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            if (!contents.contains(pkg.replace('.', '/') + "/")) continue;
            return artifact.getVersion();
        }
        return "0.0.0";
    }
}

