/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pdk;

import com.atlassian.maven.plugins.pdk.BasePluginServerMojo;
import com.atlassian.maven.plugins.pdk.RescanPluginsMojo;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.JSONException;
import org.json.JSONObject;

public class InstallPluginMojo
extends BasePluginServerMojo {
    private static final String UPLOAD = "upload";
    private static final String COPY = "copy";
    public static final String PENDING_TASK_JSON = "application/vnd.atl.plugins.pending-task+json";
    public static final String UPM_ROOT_RESOURCE = "/rest/plugins/1.0/";
    protected String installMethod = "upload";
    protected File pluginsHome;
    protected File pluginFile;

    @Override
    protected String getTitle() {
        return "Install Plugin";
    }

    @Override
    protected boolean checkProperties() {
        if (this.installMethod == null || !UPLOAD.equalsIgnoreCase(this.installMethod) && !COPY.equalsIgnoreCase(this.installMethod)) {
            this.getLog().error((CharSequence)"Please specify either 'upload' or 'copy' for the 'atlassian.pdk.install.method' property.");
            return true;
        }
        if (COPY.equals(this.installMethod) && this.pluginsHome == null) {
            this.getLog().error((CharSequence)"Please specify the 'atlassian.pdk.server.home' property.");
            return true;
        }
        if (this.pluginFile == null) {
            this.getLog().error((CharSequence)"The plugin file could not be found.");
            return true;
        }
        if (!this.pluginFile.exists() || !this.pluginFile.isFile()) {
            this.getLog().error((CharSequence)("The required plugin file does not exist: " + this.pluginFile.getAbsolutePath()));
            return true;
        }
        return super.checkProperties();
    }

    @Override
    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.checkProperties()) {
            return;
        }
        if (COPY.equals(this.installMethod)) {
            this.copyFiles(this.pluginFile, this.pluginsHome);
            this.getLog().info((CharSequence)(this.getTitle() + ": Copied the plugin to '" + this.pluginsHome + "'"));
            RescanPluginsMojo rp = new RescanPluginsMojo();
            rp.init(this.username, this.password, this.serverUrl, this.pluginKey);
            rp.execute();
        } else if (UPLOAD.equals(this.installMethod)) {
            this.uploadFile();
        }
    }

    private void uploadFile() throws MojoExecutionException {
        DefaultClientConfig config = new DefaultClientConfig();
        this.configureSSL(this.serverUrl, (ClientConfig)config);
        Client client = Client.create((ClientConfig)config);
        if (this.getLog().isDebugEnabled()) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
        client.addFilter((ClientFilter)new BasicAuthFilter(this.username, this.password));
        client.setFollowRedirects(Boolean.valueOf(false));
        URI uri = URI.create(this.serverUrl + UPM_ROOT_RESOURCE);
        FormDataMultiPart pluginPart = new FormDataMultiPart();
        pluginPart.field("plugin", (Object)this.pluginFile, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        MediaType multipartFormDataWithBoundary = new MediaType(MediaType.MULTIPART_FORM_DATA_TYPE.getType(), MediaType.MULTIPART_FORM_DATA_TYPE.getSubtype(), (Map)ImmutableMap.builder().put((Object)"boundary", (Object)"some simple boundary").build());
        WebResource resource = client.resource(uri.toASCIIString());
        String token = "badtoken";
        ClientResponse tokenResponse = resource.head();
        token = (String)tokenResponse.getMetadata().getFirst((Object)"upm-token");
        if (token == null) {
            this.getLog().info((CharSequence)(this.getTitle() + ": Couldn't get the token from upm. Headers. Falling back to legacy upload."));
            this.legacyUploadFile();
            return;
        }
        this.getLog().info((CharSequence)(this.getTitle() + ": Uploading '" + this.pluginFile.getName() + "' to server via UPM: " + this.serverUrl));
        ClientResponse acceptResponse = (ClientResponse)((WebResource.Builder)resource.queryParam("token", token).header("X-Atlassian-Token", (Object)"no-check").type(multipartFormDataWithBoundary)).post(ClientResponse.class, (Object)pluginPart);
        try {
            this.waitForCompletion(client, acceptResponse);
        }
        catch (AsynchronousTaskException ate) {
            throw new MojoExecutionException(this.getTitle() + " : Upload failed --- " + ate.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void legacyUploadFile() throws MojoExecutionException {
        HttpClient client = new HttpClient();
        String url = this.serverUrl + "/admin/uploadplugin.action" + "?os_username=" + this.urlEncode(this.username) + "&os_password=" + this.urlEncode(this.password);
        MultipartPostMethod filePost = new MultipartPostMethod(url);
        filePost.setDoAuthentication(true);
        filePost.setFollowRedirects(true);
        filePost.setRequestHeader("X-Atlassian-Token", "no-check");
        try {
            filePost.addParameter("file_0", this.pluginFile.getName(), this.pluginFile);
            client.setConnectionTimeout(5000);
            this.getLog().info((CharSequence)(this.getTitle() + ": Uploading '" + this.pluginFile.getName() + "' to server: " + this.serverUrl));
            int status = client.executeMethod(filePost.getHostConfiguration(), (HttpMethod)filePost, this.getHttpState());
            if (status == 302) {
                Header location = filePost.getResponseHeader("Location");
                if (location == null) {
                    throw new MojoExecutionException(this.getTitle() + ": Upload failed[" + status + "]: Redirecing to an unknown location");
                }
                if (location.getValue().indexOf("/login.action") >= 0) {
                    throw new MojoExecutionException(this.getTitle() + ": Upload failed[" + status + "]: This is likely due to a non-existent or underpriviledged user: " + this.username);
                }
            } else if (status != 200) {
                throw new MojoExecutionException(this.getTitle() + ": Upload failed[" + status + "]: " + HttpStatus.getStatusText((int)status));
            }
            this.getLog().info((CharSequence)(this.getTitle() + ": Completed successfully[" + status + "]."));
        }
        catch (ConnectException e) {
            this.getLog().error((CharSequence)(this.getTitle() + ": Unable to connect to '" + this.serverUrl + "': " + e.getMessage()));
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)(this.getTitle() + ": Unable to find file to upload: " + e.getMessage()));
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            filePost.releaseConnection();
        }
    }

    private void configureSSL(String url, ClientConfig config) throws MojoExecutionException {
        SSLContext ctx;
        if (url.startsWith("https:")) {
            return;
        }
        try {
            ctx = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Can't initialise the SSL context", (Exception)e);
        }
        TrustManager[] myTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            ctx.init(null, myTrustManager, null);
        }
        catch (KeyManagementException e) {
            throw new MojoExecutionException("Can't initialise the SSL context", (Exception)e);
        }
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hostnameVerifier, ctx));
    }

    public void waitForCompletion(Client client, ClientResponse acceptResponse) {
        URI taskLocation = acceptResponse.getLocation();
        WebResource taskResource = client.resource(taskLocation);
        ClientResponse clientResponse = null;
        for (int i = 0; i < 30; ++i) {
            clientResponse = (ClientResponse)taskResource.accept(new String[]{PENDING_TASK_JSON}).get(ClientResponse.class);
            if (this.isAdditionalTaskRequested(clientResponse)) {
                String entity = (String)clientResponse.getEntity(String.class);
                try {
                    this.executeNextTask(client, new JSONObject(entity));
                    break;
                }
                catch (JSONException e) {
                    throw new AsynchronousTaskException("Failed to parse JSON : " + entity, e);
                }
            }
            if (clientResponse.getStatus() != Response.Status.OK.getStatusCode()) break;
            if (this.isTaskErrorRepresentation(clientResponse)) {
                throw new AsynchronousTaskException((String)clientResponse.getEntity(String.class));
            }
            if (this.isTaskDone(clientResponse)) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void executeNextTask(Client client, JSONObject object) throws JSONException {
        JSONObject status = object.getJSONObject("status");
        if (status == null) {
            throw new AsynchronousTaskException("Cannot parse status from : " + object);
        }
        if (status.has("nextTaskPostUri")) {
            this.getLog().info((CharSequence)(this.getTitle() + ": Triggering UPM self-update"));
            WebResource resource = client.resource(status.getString("nextTaskPostUri"));
            ClientResponse response = (ClientResponse)resource.post(ClientResponse.class);
            this.waitForCompletion(client, response);
        } else if (status.has("cleanupDeleteUri")) {
            this.getLog().info((CharSequence)(this.getTitle() + ": Uninstalling UPM self-update stub plugin"));
            WebResource resource = client.resource(status.getString("cleanupDeleteUri"));
            resource.delete(ClientResponse.class);
        } else {
            throw new AsynchronousTaskException("status should contain nextTaskPostUri or nextTaskDeleteUri, but was: " + status);
        }
    }

    private boolean isAdditionalTaskRequested(ClientResponse response) {
        return response.getStatus() == Response.Status.ACCEPTED.getStatusCode() && response.getType().getSubtype().endsWith("next-task+json");
    }

    private boolean isTaskErrorRepresentation(ClientResponse response) {
        return response.getType().getSubtype().endsWith("err+json");
    }

    private boolean isTaskDone(ClientResponse response) {
        return response.getType().getSubtype().endsWith("complete+json");
    }

    @Override
    protected String getMode() {
        return null;
    }

    final class BasicAuthFilter
    extends ClientFilter {
        private final String auth;

        BasicAuthFilter(String username, String password) {
            try {
                this.auth = "Basic " + new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes("ASCII")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("That's some funky JVM you've got there", e);
            }
        }

        public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
            MultivaluedMap headers = cr.getMetadata();
            if (!headers.containsKey((Object)"Authorization")) {
                headers.add((Object)"Authorization", (Object)this.auth);
            }
            return this.getNext().handle(cr);
        }
    }

    private static class AsynchronousTaskException
    extends RuntimeException {
        public AsynchronousTaskException(String s, Throwable cause) {
            super(s, cause);
        }

        public AsynchronousTaskException(String s) {
            super(s);
        }
    }
}

