/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pdk;

import com.atlassian.maven.plugins.pdk.BasePdkMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class BundleJarsMojo
extends BasePdkMojo {
    private static final String META_INF = "META-INF";
    private static final String DEFAULT_EXCLUDES = "META-INF/*.SF,META-INF/*.sf,META-INF/*.DSA,META-INF/*.dsa,META-INF/*.RSA,META-INF/*.rsa";
    private MavenProject project;
    private boolean extractDependencies;
    private String localRepository;
    private String target;
    private File workDirectory;
    private String dependencyIncludes = "**";
    private String dependencyExcludes = "META-INF/*.SF,META-INF/*.sf,META-INF/*.DSA,META-INF/*.dsa,META-INF/*.RSA,META-INF/*.rsa";
    protected ArchiverManager archiverManager;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public void execute() throws MojoExecutionException, MojoFailureException {
        File destFile = new File(this.target);
        try {
            this.bundleDependencies(this.project, destFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure while building project", (Exception)e);
        }
    }

    public void bundleDependencies(MavenProject project, File buildDir) throws MojoExecutionException, IOException, MojoFailureException {
        this.getLog().info((CharSequence)("Bundling dependencies for '" + project.getArtifactId() + "' in " + buildDir));
        File metainfDir = new File(buildDir, META_INF);
        metainfDir.mkdirs();
        File libDirectory = new File(metainfDir, "lib");
        Set artifacts = project.getArtifacts();
        List duplicates = this.findDuplicates(artifacts);
        ArrayList<File> dependencyDirectories = new ArrayList<File>();
        for (Artifact artifact : artifacts) {
            String targetFileName = this.getDefaultFinalName(artifact);
            this.getLog().debug((CharSequence)("Processing: " + targetFileName));
            if (duplicates.contains(targetFileName)) {
                this.getLog().debug((CharSequence)("Duplicate found: " + targetFileName));
                targetFileName = artifact.getGroupId() + "-" + targetFileName;
                this.getLog().debug((CharSequence)("Renamed to: " + targetFileName));
            }
            ScopeArtifactFilter runtimeFilter = new ScopeArtifactFilter("runtime");
            ScopeArtifactFilter compileFilter = new ScopeArtifactFilter("compile");
            if (artifact.isOptional() || !runtimeFilter.include(artifact) && !compileFilter.include(artifact)) continue;
            String type = artifact.getType();
            if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type)) {
                this.getLog().info((CharSequence)("Bundling '" + artifact.getArtifactId() + "' into plugin."));
                if (this.extractDependencies) {
                    dependencyDirectories.add(this.unpackToTempDirectory(artifact));
                    continue;
                }
                BundleJarsMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("par".equals(type)) {
                targetFileName = targetFileName.substring(0, targetFileName.lastIndexOf(46)) + ".jar";
                this.getLog().debug((CharSequence)("Copying " + artifact.getFile() + " to " + new File(libDirectory, targetFileName)));
                this.getLog().info((CharSequence)("Bundling '" + artifact.getArtifactId() + "' into plugin."));
                if (this.extractDependencies) {
                    dependencyDirectories.add(this.unpackToTempDirectory(artifact));
                    continue;
                }
                BundleJarsMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("war".equals(type)) {
                dependencyDirectories.add(this.unpackToTempDirectory(artifact));
                continue;
            }
            this.getLog().info((CharSequence)("Not bundling '" + artifact.getArtifactId() + "' - unsupported type: " + type));
        }
        if (dependencyDirectories.size() > 0) {
            this.getLog().info((CharSequence)("Overlaying " + dependencyDirectories.size() + " dependencies."));
            Iterator iter = dependencyDirectories.iterator();
            while (iter.hasNext()) {
                this.copyDependencyContents((File)iter.next(), buildDir);
            }
        }
    }

    private List findDuplicates(Set artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            String candidate = this.getDefaultFinalName(artifact);
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private String getDefaultFinalName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
    }

    private static void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
            destination.setLastModified(source.lastModified());
        }
    }

    private File unpackToTempDirectory(Artifact artifact) throws MojoExecutionException {
        String name = artifact.getFile().getName();
        File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
        boolean process = false;
        if (!tempLocation.exists()) {
            tempLocation.mkdirs();
            process = true;
        } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
            process = true;
        }
        if (process) {
            File file = artifact.getFile();
            try {
                this.unpack(file, tempLocation);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
        return tempLocation;
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.setOverwrite(true);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }

    private void copyDependencyContents(File srcDir, File targetDir) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcDir);
        scanner.setExcludes(this.getDependencyExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getDependencyIncludes());
        scanner.scan();
        String[] dirs = scanner.getIncludedDirectories();
        for (int j = 0; j < dirs.length; ++j) {
            new File(targetDir, dirs[j]).mkdirs();
        }
        String[] files = scanner.getIncludedFiles();
        for (int j = 0; j < files.length; ++j) {
            File srcFile = new File(srcDir, files[j]);
            File targetFile = new File(targetDir, files[j]);
            try {
                File parentDir = targetFile.getParentFile();
                parentDir.mkdirs();
                if (!parentDir.isDirectory()) {
                    this.getLog().warn((CharSequence)("Skipping " + files[j] + ": failed to create parent directory " + parentDir));
                    continue;
                }
                if (targetFile.isDirectory() && srcFile.isFile() || srcFile.isDirectory() && targetFile.isFile()) {
                    this.getLog().warn((CharSequence)("Skipping " + files[j] + ": conflicts with existing file " + targetFile));
                    continue;
                }
                BundleJarsMojo.copyFileIfModified(srcFile, targetFile);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file '" + files[j] + "' to '" + targetFile + "'", (Exception)e);
            }
        }
    }

    protected String[] getDependencyExcludes() {
        String[] excludes = StringUtils.isNotEmpty((String)this.dependencyExcludes) ? StringUtils.split((String)this.dependencyExcludes, (String)",") : EMPTY_STRING_ARRAY;
        return excludes;
    }

    protected String[] getDependencyIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.dependencyIncludes), (String)",");
    }

    public void setExtractDependencies(boolean extractDependencies) {
        this.extractDependencies = extractDependencies;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void setDependencyExcludes(String dependencyExcludes) {
        this.dependencyExcludes = dependencyExcludes;
    }
}

