package com.atlassian.maven.plugins.updater;

/** Types of SDK packages available for download from Marketplace. */
public enum SdkPackageType {
    WINDOWS("windows", ".exe", true, "cmd.exe", "/C"),
    MAC("mac", ".pkg", true, "open"),
    RPM("rpm", ".rpm", true, "sudo", "rpm", "-Uvh"),
    DEB("deb", ".deb", true, "sudo", "dpkg", "-i"),
    TGZ("tgz", ".tar.gz", false);

    private final String key;
    private final String suffix;
    private final boolean isObsolete;
    private final String[] installCommands;

    SdkPackageType(String key, String suffix, boolean isObsolete, String... installCommands) {
        this.key = key;
        this.suffix = suffix;
        this.isObsolete = isObsolete;
        this.installCommands = installCommands;
    }

    public String key() {
        return key;
    }

    public String[] installCommands() {
        return installCommands;
    }

    public boolean isObsolete() {
        return isObsolete;
    }

    public String getSuffix() {
        return suffix;
    }

    public static SdkPackageType getType(String key) {
        if (key.equals("windows")) {
            return WINDOWS;
        } else if (key.equals("mac")) {
            return MAC;
        } else if (key.equals("rpm")) {
            return RPM;
        } else if (key.equals("deb")) {
            return DEB;
        } else if (key.equals("tgz")) {
            return TGZ;
        } else return TGZ;
    }
}
