package com.atlassian.maven.plugins.amps;

import java.io.File;

import com.atlassian.maven.plugins.amps.product.manager.BaseUrlUtils;

public class InstallParams {

    private static final String UPM_ROOT_RESOURCE = "/rest/plugins/1.0/";

    private final String pluginKey;
    private final String serverUrl;
    private final String username;
    private final String password;
    private final File pluginFile;
    private final String signature;

    private InstallParams(
            String pluginKey,
            String server,
            int port,
            String contextPath,
            String username,
            String password,
            File pluginFile,
            String signature) {
        this.pluginKey = pluginKey;
        serverUrl = BaseUrlUtils.getBaseUrl(server, port, contextPath);
        this.username = username;
        this.password = password;
        this.pluginFile = pluginFile;
        this.signature = signature;
    }

    public String getPluginKey() {
        return pluginKey;
    }

    public String getServerUrl() {
        return serverUrl;
    }

    public String getUpmUrl() {
        return serverUrl + UPM_ROOT_RESOURCE;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public File getPluginFile() {
        return pluginFile;
    }

    public String getSignature() {
        return signature;
    }

    public static class Builder {
        private String pluginKey;
        private String server;
        private int port;
        private String contextPath;
        private String username;
        private String password;
        private File pluginFile;
        private String signature;

        public Builder pluginKey(String pluginKey) {
            this.pluginKey = pluginKey;
            return this;
        }

        public Builder server(String server) {
            this.server = server;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder pluginFile(File file) {
            this.pluginFile = file;
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public InstallParams build() {
            return new InstallParams(pluginKey, server, port, contextPath, username, password, pluginFile, signature);
        }
    }
}
