/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.upm.signing.tools.PrivateKeyAndCert;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCertificateBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomCertificateBuilder.class);
    private String issuer;
    private String name;
    private String duration;
    private String startOffset;

    public String getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(String startOffset) {
        this.startOffset = startOffset;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getName() {
        String notNull = this.name == null ? this.issuer : this.name;
        return notNull.replaceAll("\\s", "_");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public boolean isEmpty() {
        return this.name == null && this.issuer == null && this.duration == null && this.startOffset == null;
    }

    public PrivateKeyAndCert createPrivateKeyAndCertificate() {
        Duration d = this.safeParse(this.duration).orElse(Duration.ofDays(1L));
        ZonedDateTime start = ZonedDateTime.now();
        if (this.startOffset != null) {
            String offset = this.startOffset;
            BiFunction<ZonedDateTime, Duration, ZonedDateTime> func = ZonedDateTime::plus;
            if (this.startOffset.startsWith("-")) {
                offset = this.startOffset.substring(1);
                func = ZonedDateTime::minus;
            }
            Duration offsetDuration = this.safeParse(offset).orElse(Duration.ZERO);
            start = func.apply(start, offsetDuration);
        }
        return PrivateKeyAndCert.generateSelfSignedX509Certificate((ZonedDateTime)start, (ZonedDateTime)start.plus(d), (String)this.issuer);
    }

    private Optional<Duration> safeParse(String duration) {
        if (duration == null || StringUtils.isBlank((CharSequence)duration)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Duration.parse(duration));
        }
        catch (DateTimeParseException dateTimeParseException) {
            LOGGER.warn("Failed to parse duration for Custom Certificate {} : {}", (Object)this.name, (Object)duration);
            return Optional.empty();
        }
    }
}

