/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification.impl;

import com.atlassian.maven.plugins.amps.frontend.association.FeManifestAssociationConstants;
import com.atlassian.maven.plugins.amps.frontend.association.verification.ArtifactScanner;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ArtifactScanResults;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ModuleScanResults;
import de.schlichtherle.truezip.file.TFile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ArtifactScannerImpl
implements ArtifactScanner {
    public static final Set<String> SUPPORTED_ARCHIVE_EXTENSIONS = Stream.of("jar", "war", "obr", "tar.gz", "zip").collect(Collectors.toCollection(HashSet::new));
    private static final HashSet<String> MODULE_METADATA_DIRS = Stream.of("META-INF", "WEB-INF").collect(Collectors.toCollection(HashSet::new));

    @Override
    public ArtifactScanResults scan(TFile root) throws MojoExecutionException {
        if (!root.exists()) {
            throw new MojoExecutionException(String.format("Provided artifact doesn't exist: %s", root.getPath()));
        }
        ArtifactScanResults results = new ArtifactScanResults();
        this.explore(root, results);
        return results;
    }

    private void explore(TFile root, ArtifactScanResults results) {
        TFile[] entries = root.listFiles();
        if (entries == null) {
            return;
        }
        boolean isJavaModule = this.checkIfModuleMetaExists(entries);
        if (isJavaModule) {
            this.exploreModule(root, root, results);
        } else {
            this.exploreRoot(root, results);
        }
    }

    private void exploreModule(TFile root, TFile moduleRoot, ArtifactScanResults results) {
        TFile[] entries = root.listFiles();
        if (entries == null) {
            return;
        }
        for (TFile entry : entries) {
            ModuleScanResults moduleScanResults;
            if (entry.isDirectory()) {
                if (this.isArchiveFile(entry)) {
                    results.getArchiveFiles().add(entry);
                    continue;
                }
                this.exploreModule(entry, moduleRoot, results);
                continue;
            }
            if (this.isJsFile(entry)) {
                moduleScanResults = this.getModuleScanResults(results, moduleRoot);
                moduleScanResults.getJavascriptFiles().add(entry);
                continue;
            }
            if (this.isAssociationFile(entry)) {
                moduleScanResults = this.getModuleScanResults(results, moduleRoot);
                moduleScanResults.getAssociationFiles().add(entry);
                continue;
            }
            if (!this.isExternalDependencyDeclarationFile(entry)) continue;
            moduleScanResults = this.getModuleScanResults(results, moduleRoot);
            moduleScanResults.getNestedDeclarationFiles().add(entry);
        }
    }

    private void exploreRoot(TFile root, ArtifactScanResults results) {
        TFile[] entries = root.listFiles();
        if (entries == null) {
            return;
        }
        for (TFile entry : entries) {
            if (entry.isDirectory()) {
                if (this.isArchiveFile(entry)) {
                    results.getArchiveFiles().add(entry);
                    continue;
                }
                this.explore(entry, results);
                continue;
            }
            if (!this.isJsFile(entry)) continue;
            ModuleScanResults moduleScanResults = this.getModuleScanResults(results, root);
            moduleScanResults.getJavascriptFiles().add(entry);
        }
    }

    private ModuleScanResults getModuleScanResults(ArtifactScanResults results, TFile moduleRoot) {
        Map<TFile, ModuleScanResults> modules = results.getModules();
        if (modules.containsKey(moduleRoot)) {
            return results.getModules().get(moduleRoot);
        }
        ModuleScanResults moduleScanResults = new ModuleScanResults();
        modules.put(moduleRoot, moduleScanResults);
        return moduleScanResults;
    }

    private boolean checkIfModuleMetaExists(TFile[] entries) {
        return Arrays.stream(entries).anyMatch(entry -> entry.isDirectory() && MODULE_METADATA_DIRS.contains(entry.getName()));
    }

    private boolean isArchiveFile(TFile file) {
        return file.isArchive() && this.hasOneOfExtensions(file, SUPPORTED_ARCHIVE_EXTENSIONS);
    }

    private boolean isAssociationFile(TFile file) {
        return file.getName().equals("fe-manifest-association.json");
    }

    private boolean isExternalDependencyDeclarationFile(TFile file) {
        return file.getName().equals("fe-external-dependencies-with-js-files.json");
    }

    private boolean isJsFile(TFile file) {
        return FeManifestAssociationConstants.JAVASCRIPT_FILE_REGEX.matcher(file.getName()).matches();
    }

    private boolean hasOneOfExtensions(TFile file, Set<String> extensions) {
        return extensions.contains(FilenameUtils.getExtension((String)file.getName()));
    }
}

