/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.frontend.CopyFeModuleManifestsMojo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="copy-fe-bundled-metadata", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CopyFeBundledMetadataMojo
extends AbstractAmpsMojo {
    public static final String BUNDLED_METADATA_OUTPUT_DIR = "META-INF/fe-bundled-metadata";
    @Parameter(property="excludeFeBundledMetadata", defaultValue="false")
    private Boolean excludeFeBundledMetadata;
    @Parameter(property="extractDependencies", defaultValue="true")
    private Boolean extractDependencies;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.excludeFeBundledMetadata.booleanValue() && this.extractDependencies.booleanValue()) {
            this.getLog().info((CharSequence)"Copying bundled frontend metadata");
            this.copyBundledMetadata();
        } else {
            this.getLog().info((CharSequence)"Skipped copying bundled frontend metadata");
        }
    }

    private void copyBundledMetadata() throws MojoExecutionException {
        List<String> includedPatterns = Stream.of(this.getFeManifestsPatterns(), this.getFeAssociationsPatterns()).flatMap(Collection::stream).collect(Collectors.toList());
        String outputDirectory = String.format("${project.build.outputDirectory}/%s", BUNDLED_METADATA_OUTPUT_DIR);
        this.getMavenGoals().extractBundledFeModuleManifests(includedPatterns, outputDirectory);
    }

    private List<String> getFeManifestsPatterns() {
        return CopyFeModuleManifestsMojo.SUPPORTED_FILE_NAMES.stream().map(fileName -> String.format("%s/**/%s", "META-INF/fe-module-manifests", fileName)).collect(Collectors.toList());
    }

    private List<String> getFeAssociationsPatterns() {
        return Collections.singletonList(String.format("%s/**/%s", "META-INF/fe-manifest-associations", "fe-manifest-association.json"));
    }
}

