/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.analytics.event.AnalyticsEvent;
import com.atlassian.maven.plugins.amps.analytics.event.impl.AnalyticsEventFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends AbstractTestGroupsHandlerMojo {
    @Parameter(property="wait", defaultValue="true")
    private boolean wait;
    @Parameter(property="amps.properties", required=true, defaultValue="false")
    protected boolean writePropertiesToFile;
    @Parameter(property="runLastProject", required=true, defaultValue="false")
    @VisibleForTesting
    boolean runLastProject;
    @Parameter(property="runProject")
    @VisibleForTesting
    String runProject;
    protected final Map<String, String> propertiesToWriteToFile = new HashMap<String, String>();

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkipCurrentProject()) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.getUpdateChecker().check();
        this.getAmpsPluginVersionChecker().checkAmpsVersionInPom(this.getAmpsPluginVersion(), this.getMavenContext().getProject());
        this.trackFirstRunIfNeeded();
        this.sendAnalyticsEvent(this.getAnalyticsEvent());
        List<Product> products = this.getProductsToExecute();
        this.beforeStart(products);
        this.startProducts(products);
    }

    protected void beforeStart(List<Product> productsToExecute) throws MojoExecutionException {
    }

    @Override
    protected boolean isStartingProduct() {
        return true;
    }

    @Nonnull
    protected AnalyticsEvent getAnalyticsEvent() {
        return AnalyticsEventFactory.run();
    }

    protected final void startProducts(List<Product> products) throws MojoExecutionException {
        if (this.wait) {
            this.addStopProductsShutdownHook(products);
        }
        long globalStartTime = System.nanoTime();
        this.setParallelMode(products);
        ArrayList<StartupInformation> successMessages = new ArrayList<StartupInformation>();
        boolean onlyOneProduct = products.size() == 1;
        for (Product product : products) {
            successMessages.add(this.startProduct(product, onlyOneProduct));
        }
        if (this.writePropertiesToFile) {
            this.writePropertiesFile();
        }
        if (this.parallel) {
            this.waitForProducts(products, true);
        }
        this.logSuccessMessages(globalStartTime, successMessages);
        if (this.wait) {
            this.awaitShutdownCommand();
            this.stopProducts(products);
        }
    }

    private StartupInformation startProduct(Product product, boolean onlyProduct) throws MojoExecutionException {
        if (product.isInstallPlugin() == null) {
            product.setInstallPlugin(this.shouldInstallPlugin());
        }
        if (this.shouldBuildTestPlugin()) {
            product.addBundledArtifacts(this.getTestFrameworkPlugins());
        }
        this.logStartingMessage(product);
        long startTime = System.nanoTime();
        List<Node> nodes = this.getProductHandler(product.getId()).start(product);
        long durationSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
        StartupInformation message = new StartupInformation(product, "started successfully", nodes, durationSeconds);
        if (!this.parallel) {
            this.getLog().info((CharSequence)message.toString());
        }
        if (this.writePropertiesToFile) {
            this.setPropertiesToWriteToFile(onlyProduct, product);
        }
        return message;
    }

    private void logSuccessMessages(long globalStartTime, Collection<StartupInformation> successMessages) {
        long globalDurationSeconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - globalStartTime);
        if (successMessages.size() > 1 || this.parallel) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("=== Summary (total time " + globalDurationSeconds + "s):"));
            for (StartupInformation message : successMessages) {
                if (!StringUtils.isNotBlank((CharSequence)message.getOutput())) continue;
                this.getLog().info((CharSequence)("Log available at: " + message.getOutput()));
            }
            for (StartupInformation message : successMessages) {
                this.getLog().info((CharSequence)message.toString());
            }
        }
    }

    private void logStartingMessage(Product product) {
        this.getLog().info((CharSequence)"");
        if (StringUtils.isBlank((CharSequence)product.getOutput())) {
            this.getLog().info((CharSequence)String.format("Starting %s...", product.getInstanceId()));
        } else {
            this.getLog().info((CharSequence)String.format("Starting %s... (see log at %s)", product.getInstanceId(), product.getOutput()));
        }
    }

    private void setPropertiesToWriteToFile(boolean onlyProduct, Product product) {
        List<Integer> nodeWebPorts = product.getWebPorts();
        if (nodeWebPorts.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one node");
        }
        int firstWebPort = nodeWebPorts.get(0);
        if (onlyProduct) {
            this.propertiesToWriteToFile.put("http.port", String.valueOf(firstWebPort));
            this.propertiesToWriteToFile.put("context.path", product.getContextPath());
        }
        this.propertiesToWriteToFile.put("context." + product.getInstanceId() + ".path", product.getContextPath());
        this.propertiesToWriteToFile.put("http." + product.getInstanceId() + ".port", String.valueOf(firstWebPort));
        this.propertiesToWriteToFile.put("baseurl." + product.getInstanceId(), product.getBaseUrlForPort(firstWebPort));
        for (int i = 0; i < nodeWebPorts.size(); ++i) {
            int webPort = nodeWebPorts.get(i);
            this.propertiesToWriteToFile.put("http." + product.getInstanceId() + ".port." + i, String.valueOf(webPort));
            this.propertiesToWriteToFile.put("baseurl." + product.getInstanceId() + "." + i, product.getBaseUrlForPort(webPort));
        }
    }

    private void awaitShutdownCommand() {
        this.getLog().info((CharSequence)"Type Ctrl-C to shutdown gracefully");
        try {
            while (System.in.read() != -1) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addStopProductsShutdownHook(Collection<Product> products) {
        this.getLog().debug((CharSequence)"=======> ADDING SHUTDOWN HOOK\n");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.getLog().info((CharSequence)"Running Shutdown Hook");
            try {
                this.stopProducts(products);
            }
            catch (MojoExecutionException e) {
                throw new IllegalStateException("Unable to shut down products in shutdown hook", e);
            }
        }, "AMPS product shutdown"));
    }

    private boolean shouldInstallPlugin() {
        Artifact artifact = this.getMavenContext().getProject().getArtifact();
        return this.installPlugin && artifact != null && !"pom".equalsIgnoreCase(artifact.getType());
    }

    private void writePropertiesFile() throws MojoExecutionException {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : this.propertiesToWriteToFile.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        File ampsProperties = new File(this.getMavenContext().getProject().getBuild().getDirectory(), "amps.properties");
        try (FileOutputStream out = new FileOutputStream(ampsProperties);){
            props.store(out, "");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing " + ampsProperties.getAbsolutePath(), (Exception)e);
        }
    }

    protected final boolean shouldSkipCurrentProject() {
        MavenContext mavenContext = this.getMavenContext();
        MavenProject currentProject = mavenContext.getProject();
        this.getLog().debug((CharSequence)String.format("Current project ID: %s, runLastProject=%b, runProject=%s", currentProject.getArtifactId(), this.runLastProject, this.runProject));
        if (StringUtils.isNotBlank((CharSequence)this.runProject)) {
            return !StringUtils.equalsIgnoreCase((CharSequence)this.runProject, (CharSequence)currentProject.getArtifactId());
        }
        if (this.runLastProject) {
            List<MavenProject> reactor = mavenContext.getReactor();
            if (reactor == null || reactor.isEmpty()) {
                return false;
            }
            MavenProject lastProject = reactor.get(reactor.size() - 1);
            return !currentProject.equals((Object)lastProject);
        }
        return false;
    }

    private static class StartupInformation {
        private final List<Node> nodes;
        private final long durationSeconds;
        private final String event;
        private final Product product;

        StartupInformation(Product product, String event, List<Node> nodes, long durationSeconds) {
            this.nodes = Collections.unmodifiableList(nodes);
            this.product = Objects.requireNonNull(product);
            this.event = Objects.requireNonNull(event);
            this.durationSeconds = durationSeconds;
        }

        public String toString() {
            String mode = Boolean.FALSE.equals(this.product.getSynchronousStartup()) ? " (asynchronously)" : "";
            String message = String.format("%s %s in %ds", this.product.getInstanceId(), this.event + mode, this.durationSeconds);
            int[] httpPorts = this.nodes.stream().mapToInt(Node::getWebPort).filter(p -> p > 0).toArray();
            if (httpPorts.length > 0) {
                String contextPath = "ROOT".equals(this.product.getContextPath()) ? "" : this.product.getContextPath();
                message = message + " at ";
                message = message + Arrays.stream(httpPorts).mapToObj(port -> this.product.getProtocol() + "://localhost:" + port + contextPath).collect(Collectors.joining(" and "));
            }
            return message;
        }

        public String getOutput() {
            return this.product.getOutput();
        }
    }
}

