/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.PlatformDependenciesProvider;
import com.atlassian.maven.plugins.amps.PlatformDependencyProvisioningException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlatformDependenciesProviderImpl
implements PlatformDependenciesProvider {
    private static final Logger log = LoggerFactory.getLogger(PlatformDependenciesProviderImpl.class);
    private final MavenXpp3Reader mavenReader = new MavenXpp3Reader();
    private RepositorySystemSession repositorySystemSession;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private MavenProject mavenProject;

    PlatformDependenciesProviderImpl() {
    }

    @Override
    public Collection<String> getDependencies(String groupId, Collection<String> artifactIds, String version) throws PlatformDependencyProvisioningException {
        ArrayList<Set<String>> dependencies = new ArrayList<Set<String>>();
        for (String artifactId : artifactIds) {
            dependencies.add(this.readSingleArtifact(groupId, artifactId, version));
        }
        return dependencies.stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    private Set<String> readSingleArtifact(String groupId, String artifactId, String version) throws PlatformDependencyProvisioningException {
        Artifact artifact = this.loadArtifact(this.determineArtifact(groupId, artifactId, version));
        List<Dependency> dependencies = this.readPomDependencies(artifact);
        return dependencies.stream().map(dependency -> String.format("%s:%s", dependency.getGroupId(), dependency.getArtifactId())).collect(Collectors.toSet());
    }

    private Artifact determineArtifact(String groupId, String artifactId, String version) throws PlatformDependencyProvisioningException {
        VersionRangeResult result;
        assert (this.mavenProject != null) : "mavenProject must not be null";
        assert (this.repositorySystem != null) : "repositorySystem must not be null";
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "pom", version);
        VersionRangeRequest request = new VersionRangeRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.mavenProject.getRemoteProjectRepositories());
        try {
            result = this.repositorySystem.resolveVersionRange(this.getSession(), request);
        }
        catch (VersionRangeResolutionException e) {
            throw new PlatformDependencyProvisioningException(String.format("Could not find artifact %s:%s for version range %s", groupId, artifactId, version), e);
        }
        if (Objects.isNull(result.getHighestVersion())) {
            result.getExceptions().forEach(exception -> log.debug(String.format("Exception (might be multiple) while looking up version range %s for %s:%s", version, groupId, artifactId), (Throwable)exception));
            throw new PlatformDependencyProvisioningException(String.format("No highest version found for %s:%s for version range %s", groupId, artifactId, version));
        }
        return artifact.setVersion(result.getHighestVersion().toString());
    }

    private Artifact loadArtifact(Artifact artifact) throws PlatformDependencyProvisioningException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest(artifact, this.mavenProject.getRemoteProjectRepositories(), null);
        try {
            result = this.repositorySystem.resolveArtifact(this.getSession(), request);
        }
        catch (ArtifactResolutionException e) {
            throw new PlatformDependencyProvisioningException(String.format("Could not load artifact %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), e);
        }
        return result.getArtifact();
    }

    private List<Dependency> readPomDependencies(Artifact artifact) throws PlatformDependencyProvisioningException {
        Model result;
        File pomFile = artifact.getFile();
        try (FileReader fileReader = new FileReader(pomFile);){
            result = this.mavenReader.read((Reader)fileReader);
        }
        catch (IOException e) {
            throw new PlatformDependencyProvisioningException(String.format("File %s is not a valid XML or cannot be read", pomFile.getPath()), e);
        }
        catch (XmlPullParserException e) {
            throw new PlatformDependencyProvisioningException(String.format("File %s is not a valid POM", pomFile.getPath()), e);
        }
        return result.getDependencies();
    }

    private RepositorySystemSession getSession() {
        if (this.repositorySystemSession == null) {
            Path localRepositoryPath = Paths.get(this.mavenProject.getBuild().getDirectory(), "local-repository");
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
            LocalRepository localRepository = new LocalRepository(localRepositoryPath.toString());
            this.repositorySystemSession = session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepository));
        }
        return this.repositorySystemSession;
    }
}

