/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.xml;

import com.atlassian.maven.plugins.amps.xml.SpringXmlComponent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JacksonXmlRootElement(localName="model")
public final class SpringXmlModel {
    private final List<SpringXmlComponent> components;

    private SpringXmlModel(List<SpringXmlComponent> components) {
        this.components = components;
    }

    @JacksonXmlProperty(localName="component")
    @JacksonXmlElementWrapper(localName="components")
    List<SpringXmlComponent> components() {
        return this.components;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SpringXmlModel model = (SpringXmlModel)other;
        return Objects.equals(model.components, this.components);
    }

    public int hashCode() {
        return Objects.hash(this.components);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SpringXmlComponent> components = new ArrayList<SpringXmlComponent>();

        private Builder() {
        }

        public Builder addComponent(SpringXmlComponent component) {
            if (component == null) {
                throw new IllegalArgumentException("'component' must not be null");
            }
            this.components.add(component);
            return this;
        }

        public SpringXmlModel build() {
            return new SpringXmlModel(Collections.unmodifiableList(this.components));
        }
    }
}

