/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.minifier.strategies.googleclosure;

import com.atlassian.maven.plugins.amps.code.Sources;
import com.atlassian.maven.plugins.amps.minifier.strategies.googleclosure.GoogleClosureOptionsHandler;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class GoogleClosureJsMinifier {
    protected static CompilerOptions getOptions(Map<String, String> closureOptions, Log log, boolean closureJsdocWarningsEnabled) {
        GoogleClosureOptionsHandler googleClosureOptionsHandler = new GoogleClosureOptionsHandler(log);
        if (closureOptions != null) {
            closureOptions.forEach(googleClosureOptionsHandler::setOption);
        }
        if (!closureJsdocWarningsEnabled) {
            WarningLevel.QUIET.setOptionsForWarningLevel(googleClosureOptionsHandler.getCompilerOptions());
        }
        return googleClosureOptionsHandler.getCompilerOptions();
    }

    public static Sources compile(String code, Map<String, String> closureOptions, Log log, boolean closureJsdocWarningsEnabled) {
        Compiler compiler = new Compiler();
        CompilerOptions options = GoogleClosureJsMinifier.getOptions(closureOptions, log, closureJsdocWarningsEnabled);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        options.setSourceMapFormat(SourceMap.Format.V3);
        options.setSourceMapOutputPath("/dummy-file-path");
        SourceFile extern = SourceFile.fromCode((String)"externs.js", (String)"function alert(x) {}");
        SourceFile input = SourceFile.fromCode((String)"input.js", (String)code);
        Result result = compiler.compile(extern, input, options);
        String min = compiler.toSource();
        StringBuilder sourceMapStream = new StringBuilder();
        try {
            result.sourceMap.appendTo((Appendable)sourceMapStream, "/dummy-file-path");
        }
        catch (IOException e) {
            log.warn((CharSequence)"can't create source map", (Throwable)e);
        }
        return new Sources(min, sourceMapStream.toString());
    }
}

