/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.database;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.database.AbstractDatabase;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@ParametersAreNonnullByDefault
public class Postgres
extends AbstractDatabase {
    private static final String ARGUMENT = "argument";
    private static final String DROP_DATABASE = "DROP DATABASE IF EXISTS \"%s\";";
    private static final String DROP_USER = "DROP USER IF EXISTS \"%s\";";
    private static final String CREATE_DATABASE = "CREATE DATABASE \"%s\";";
    private static final String CREATE_USER = "CREATE USER \"%s\" WITH PASSWORD '%s';";
    private static final String GRANT_PERMISSION = "ALTER ROLE \"%s\" superuser; ALTER DATABASE \"%s\" OWNER TO \"%s\";";
    @VisibleForTesting
    static final String PGDBNAME = "PGDBNAME";
    @VisibleForTesting
    static final String PGHOST = "PGHOST";
    @VisibleForTesting
    static final String PGPORT = "PGPORT";

    public Postgres(Log log) {
        super(log, true, "postgres72", "org.postgresql.Driver", "jdbc:postgresql");
    }

    @Override
    protected String dropDatabase(DataSource dataSource) throws MojoExecutionException {
        return String.format(DROP_DATABASE, this.getDatabaseName(dataSource));
    }

    @Override
    protected String dropUser(DataSource dataSource) {
        return String.format(DROP_USER, dataSource.getUsername());
    }

    @Override
    protected String createDatabase(DataSource dataSource) throws MojoExecutionException {
        return String.format(CREATE_DATABASE, this.getDatabaseName(dataSource));
    }

    @Override
    protected String createUser(DataSource dataSource) {
        return String.format(CREATE_USER, dataSource.getUsername(), dataSource.getPassword());
    }

    @Override
    protected String grantPermissionForUser(DataSource dataSource) throws MojoExecutionException {
        return String.format(GRANT_PERMISSION, dataSource.getUsername(), this.getDatabaseName(dataSource), dataSource.getUsername());
    }

    @Override
    public Xpp3Dom getExecMavenToolImportConfiguration(DataSource dataSource) throws MojoExecutionException {
        Xpp3Dom configDatabaseTool = null;
        if (ImportMethod.PSQL.equals((Object)ImportMethod.getValueOf(dataSource.getImportMethod()))) {
            configDatabaseTool = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "psql"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "-f" + dataSource.getDumpFilePath()), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "-U" + dataSource.getUsername()), MojoExecutor.element(MojoExecutor.name(ARGUMENT), "-h" + Postgres.getHostName(dataSource.getUrl())), MojoExecutor.element(MojoExecutor.name(ARGUMENT), this.getDatabaseName(dataSource))));
        }
        return configDatabaseTool;
    }

    private static String getHostName(String jdbcUrl) {
        return Optional.ofNullable(Postgres.parseURL(jdbcUrl)).map(urlProperties -> urlProperties.getProperty(PGHOST)).filter(StringUtils::isNotEmpty).orElseThrow(() -> new IllegalArgumentException(String.format("Could not parse host name from Postgres URL '%s'", jdbcUrl)));
    }

    @Override
    protected String getDatabaseName(DataSource dataSource) throws MojoExecutionException {
        String databaseName = "";
        try {
            Class.forName(dataSource.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load Postgresql database library from AMPS classpath");
        }
        try {
            Properties driverProps;
            String url = dataSource.getUrl();
            Driver driver = DriverManager.getDriver(url);
            DriverPropertyInfo[] driverPropertyInfos = driver.getPropertyInfo(url, null);
            if (null != driverPropertyInfos) {
                for (DriverPropertyInfo driverPropertyInfo : driverPropertyInfos) {
                    if (!PGDBNAME.equals(driverPropertyInfo.name)) continue;
                    databaseName = driverPropertyInfo.value;
                    break;
                }
            }
            if (databaseName == null && (driverProps = Postgres.parseURL(url)) != null) {
                databaseName = driverProps.getProperty(PGDBNAME);
            }
        }
        catch (SQLException e) {
            throw new MojoExecutionException("No suitable driver");
        }
        return databaseName;
    }

    @Override
    @Nonnull
    public Xpp3Dom getSqlMavenCreateConfiguration(DataSource dataSource) throws MojoExecutionException {
        String sql = this.dropDatabase(dataSource) + '\n' + this.dropUser(dataSource) + '\n' + this.createDatabase(dataSource) + '\n' + this.createUser(dataSource) + '\n' + this.grantPermissionForUser(dataSource);
        this.log.info((CharSequence)("Postgres initialization database sql: " + sql));
        Xpp3Dom pluginConfiguration = this.systemDatabaseConfiguration(dataSource);
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        return pluginConfiguration;
    }

    @Nullable
    @VisibleForTesting
    static Properties parseURL(String url) {
        String[] args;
        Properties urlProps = new Properties();
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        if (!l_urlServer.startsWith("jdbc:postgresql:")) {
            return null;
        }
        if ((l_urlServer = l_urlServer.substring("jdbc:postgresql:".length())).startsWith("//")) {
            int slash = (l_urlServer = l_urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                return null;
            }
            urlProps.setProperty(PGDBNAME, l_urlServer.substring(slash + 1));
            String[] addresses = l_urlServer.substring(0, slash).split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                    ports.append(portStr);
                    hosts.append(address.subSequence(0, portIdx));
                } else {
                    ports.append("5432");
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty(PGPORT, ports.toString());
            urlProps.setProperty(PGHOST, hosts.toString());
        } else {
            urlProps.setProperty(PGPORT, "5432");
            urlProps.setProperty(PGHOST, "localhost");
            urlProps.setProperty(PGDBNAME, l_urlServer);
        }
        for (String token : args = l_urlArgs.split("&")) {
            if (token.length() == 0) continue;
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, l_pos), token.substring(l_pos + 1));
        }
        return urlProps;
    }
}

