/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.MavenGoals;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidateBannedDependenciesExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ValidateBannedDependenciesExecutor.class);
    private final boolean skipBanningDependencies;
    private final Set<String> banningExcludes;
    private final String platformVersion;
    private final boolean forceInternalPlugin;
    private final boolean legacyValidateBannedDependencies;

    ValidateBannedDependenciesExecutor(boolean skipBanningDependencies, Set<String> banningExcludes, String platformVersion, boolean forceInternalPlugin, boolean legacyValidateBannedDependencies) {
        this.skipBanningDependencies = skipBanningDependencies;
        this.banningExcludes = banningExcludes;
        this.platformVersion = platformVersion;
        this.forceInternalPlugin = forceInternalPlugin;
        this.legacyValidateBannedDependencies = legacyValidateBannedDependencies;
    }

    void execute(MavenGoals mavenGoals) throws MojoExecutionException {
        if (this.legacyValidateBannedDependencies) {
            logger.warn("Property 'legacyValidateBannedDependencies' is deprecated and will be removed in further versions");
        }
        if (this.skipBanningDependencies) {
            logger.warn("dependencies validation has been skipped");
            return;
        }
        mavenGoals.validateBannedDependencies(this.banningExcludes, this.platformVersion(), this.forceInternalPlugin, this.legacyValidateBannedDependencies);
    }

    private String platformVersion() throws MojoExecutionException {
        if (this.platformVersion != null) {
            return this.platformVersion;
        }
        return "[0,)";
    }
}

