/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;

@ParametersAreNonnullByDefault
public final class ConfigFileUtils {
    public static void replace(List<File> files, List<Replacement> replacements, boolean inverted) throws MojoExecutionException {
        for (File file : files) {
            if (!file.exists()) continue;
            ConfigFileUtils.replace(file, replacements, inverted);
        }
    }

    private static void replace(File cfgFile, List<Replacement> replacements, boolean inverted) throws MojoExecutionException {
        try {
            String config = FileUtils.readFileToString((File)cfgFile, (Charset)StandardCharsets.UTF_8);
            if (!inverted) {
                for (Replacement replacement : replacements) {
                    if (!replacement.applyWhenUnzipping()) continue;
                    config = replacement.replace(config);
                }
            } else {
                for (Replacement replacement : replacements) {
                    config = replacement.reverse(config);
                }
            }
            FileUtils.writeStringToFile((File)cfgFile, (String)config, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to replace " + cfgFile, (Exception)ex);
        }
    }

    public static void replaceAll(File file, String pattern, String replacement) throws MojoExecutionException {
        if (!file.isFile()) {
            return;
        }
        try {
            String oldContents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            String newContents = oldContents.replaceAll(pattern, replacement);
            FileUtils.writeStringToFile((File)file, (String)newContents, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to replace " + file, (Exception)ex);
        }
    }

    public static void updateProperties(File propertiesFile, Map<String, String> newProperties) {
        Properties props = ConfigFileUtils.readProperties(propertiesFile);
        newProperties.forEach(props::setProperty);
        try (FileOutputStream out = new FileOutputStream(propertiesFile);){
            props.store(out, "Processed by AMPS");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Properties readProperties(File propertiesFile) {
        Properties props = new Properties();
        try (FileInputStream in2 = new FileInputStream(propertiesFile);){
            props.load(in2);
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return props;
    }

    private ConfigFileUtils() {
    }

    public static final class RegexReplacement
    extends Replacement {
        public RegexReplacement(String key, String value) {
            super(key, value, false);
        }

        @Override
        protected String replace(String s, String target, String replacement) {
            return s.replaceAll(target, replacement);
        }
    }

    public static class Replacement
    implements Comparable<Replacement> {
        private final String key;
        private final String value;
        private final boolean applyWhenUnzipping;
        private final boolean reversible;

        public static Replacement onlyWhenUnzipping(String key, String value) {
            return new Replacement(key, value, true, false);
        }

        public Replacement(String key, String value) {
            this(key, value, true);
        }

        public Replacement(String key, String value, boolean reversible) {
            this(key, value, true, reversible);
        }

        Replacement(String key, String value, boolean applyWhenUnzipping, boolean reversible) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            this.value = Objects.requireNonNull(value, "value must not be null");
            this.applyWhenUnzipping = applyWhenUnzipping;
            this.reversible = reversible;
        }

        public final String replace(String s) {
            return this.replace(s, this.key, this.value);
        }

        public final String reverse(String s) {
            return this.reversible ? this.replace(s, this.value, this.key) : s;
        }

        protected String replace(String s, String target, String replacement) {
            return s.replace(target, replacement);
        }

        public boolean applyWhenUnzipping() {
            return this.applyWhenUnzipping;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Replacement that = (Replacement)other;
            return this.applyWhenUnzipping == that.applyWhenUnzipping && this.reversible == that.reversible && this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.applyWhenUnzipping, this.reversible);
        }

        @Override
        public int compareTo(Replacement other) {
            int length1 = this.value.length();
            int length2 = other.value.length();
            return length2 - length1;
        }

        public String toString() {
            String operation = this.applyWhenUnzipping && this.reversible ? " <-> " : (this.applyWhenUnzipping ? " -> " : (this.reversible ? " <- " : " (nop) "));
            return this.key + operation + this.value;
        }
    }
}

