/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.i18n;

import com.atlassian.maven.plugins.amps.PostProcessor;
import com.atlassian.maven.plugins.amps.i18n.FindI18nUsageInJavascript;
import com.atlassian.maven.plugins.amps.i18n.FindI18nUsageInSoy;
import com.atlassian.maven.plugins.amps.i18n.I18nScanner;
import com.atlassian.maven.plugins.amps.util.PropertyUtils;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordI18nUsages
implements PostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordI18nUsages.class);
    private static final Map<String, I18nScanner> SCANNERS = new HashMap<String, I18nScanner>();

    private static String getSourceFilename(String filepath) {
        return FileUtils.filename((String)filepath).replaceAll("\\-min\\.(\\w+)$", ".$1").replaceAll("\\.min\\.(\\w+)$", ".$1");
    }

    private static String getOutputFilename(String filepath) {
        return RecordI18nUsages.getSourceFilename(filepath) + ".i18n.properties";
    }

    private static File getOutputFile(File file) {
        String outputDir = file.getParent();
        String outputBasename = RecordI18nUsages.getOutputFilename(file.getName());
        return new File(outputDir, outputBasename);
    }

    @Override
    public void processProjectBuild(@Nonnull Build build) {
        this.recordUsageForFilesInDirectory(build.getOutputDirectory());
    }

    @VisibleForTesting
    Collection<File> recordUsageForFilesInDirectory(@Nonnull String outputDirectory) {
        return this.recordUsageForFilesInDirectory(Paths.get(outputDirectory, new String[0]).toFile());
    }

    @VisibleForTesting
    Collection<File> recordUsageForFilesInDirectory(@Nonnull File outputDirectory) {
        if (!outputDirectory.isDirectory()) {
            LOGGER.warn("I18n output directory '{}' does not exist, skipping scan", (Object)outputDirectory);
            return Collections.emptyList();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(outputDirectory);
        scanner.addDefaultExcludes();
        scanner.setIncludes((String[])SCANNERS.keySet().stream().map(ext -> "**/*." + ext).toArray(String[]::new));
        scanner.scan();
        return Arrays.stream(scanner.getIncludedFiles()).map(s -> Paths.get(outputDirectory.getAbsolutePath(), s)).map(Path::toFile).filter(File::isFile).map(this::scanFile).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Optional<File> scanFile(@Nonnull File file) {
        File metadataFile = RecordI18nUsages.getOutputFile(file);
        if (metadataFile.isFile()) {
            LOGGER.info("I18n metadata file already exists at '{}', skipping.", (Object)metadataFile.getAbsolutePath());
            return Optional.of(metadataFile);
        }
        List<String> usedI18nKeys = this.scanFileByExtension(file);
        if (usedI18nKeys == null) {
            return Optional.empty();
        }
        Properties props = new Properties();
        this.getI18nKeyUsageCount(usedI18nKeys).forEach((key, val) -> props.setProperty((String)key, String.valueOf(val)));
        try {
            PropertyUtils.storeProperties(props, metadataFile, "Generated by AMPS version: " + VersionUtils.getVersion());
            LOGGER.info("I18n metadata written to '{}'", (Object)metadataFile.getAbsolutePath());
            return Optional.of(metadataFile);
        }
        catch (MojoExecutionException e) {
            LOGGER.error(String.format("I18n metadata cannot be written for '%s', skipping", file.getAbsolutePath()), (Throwable)e);
            return Optional.empty();
        }
    }

    private Map<String, Long> getI18nKeyUsageCount(@Nonnull Collection<String> keys) {
        return keys.stream().sorted().map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    @Nullable
    private List<String> scanFileByExtension(@Nonnull File file) {
        String ext = FileUtils.getExtension((String)file.getName()).toLowerCase();
        I18nScanner finder = SCANNERS.get(ext);
        if (finder == null) {
            LOGGER.debug("I18n scan for '{}' skipped as no scanner registered for '{}' extension", (Object)file.getAbsolutePath(), (Object)ext);
            return null;
        }
        LOGGER.info("I18n scan for '{}'", (Object)file.getAbsolutePath());
        long start = System.currentTimeMillis();
        List<String> results = finder.findI18nUsages(file);
        long end = System.currentTimeMillis();
        LOGGER.info("I18n scan found {} key(s) used, took {}ms", (Object)results.size(), (Object)(end - start));
        return results;
    }

    static {
        SCANNERS.put("js", new FindI18nUsageInJavascript());
        SCANNERS.put("soy", new FindI18nUsageInSoy());
    }
}

