/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.i18n;

import com.atlassian.maven.plugins.amps.i18n.I18nScanner;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class FindI18nUsageInJavascript
implements I18nScanner {
    private static final String I18N_KEY_GROUP = "i18nKey";
    private static final Pattern I18N_GET_TEXT_PATTERN = Pattern.compile("(?:\\.I18n|\\['I18n']|\\[\"I18n\"])\\.getText\\(\\s*(['\"])(?<i18nKey>[\\w.-]+)\\1\\s*([),])");
    private static final int LONGEST_ACCEPTED_IDENTIFIER = 120;
    private static final Pattern SINGLE_IDENTIFIER_PATTERN = Pattern.compile("((?:\\p{Alpha}|[$_])(?:\\p{Alnum}|[$_]){0,100}(?:\\[['\"]default['\"]])?(?:\\.default)?)$");

    FindI18nUsageInJavascript() {
    }

    @Override
    @Nonnull
    public List<String> findI18nUsages(@Nonnull File file) {
        return FileUtils.readFileToString(file, StandardCharsets.UTF_8).map(input -> {
            ArrayList usedI18nKeys = new ArrayList();
            Matcher i18nMatcher = I18N_GET_TEXT_PATTERN.matcher((CharSequence)input);
            Matcher singleIdentifierMatcher = SINGLE_IDENTIFIER_PATTERN.matcher((CharSequence)input);
            while (i18nMatcher.find()) {
                FindI18nUsageInJavascript.getValidI18nGetTextMatch(i18nMatcher, singleIdentifierMatcher).ifPresent(usedI18nKeys::add);
            }
            return usedI18nKeys;
        }).orElse(Collections.emptyList());
    }

    @Nonnull
    private static Optional<String> getValidI18nGetTextMatch(Matcher i18nMatcher, Matcher singleIdentifierMatcher) {
        int start = i18nMatcher.toMatchResult().start();
        singleIdentifierMatcher.region(Math.max(0, start - 120), start);
        if (!singleIdentifierMatcher.find()) {
            return Optional.empty();
        }
        return Optional.of(i18nMatcher.group(I18N_KEY_GROUP));
    }
}

