/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification.impl;

import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsReader;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.ArtifactPathUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;

public class DeclarationsReaderImpl
implements DeclarationsReader {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Set<String> readRelativeDeclarations(Collection<TFile> associationFiles, TFile moduleRoot) throws MojoExecutionException {
        Set<TFile> declaredFiles = this.readDeclarations(associationFiles).stream().map(relativePath -> new TFile((File)moduleRoot, relativePath)).collect(Collectors.toSet());
        return ArtifactPathUtils.getRelativePaths(declaredFiles, moduleRoot);
    }

    private Set<String> readDeclarations(Collection<TFile> associationFiles) throws MojoExecutionException {
        HashSet<String> declaredFiles = new HashSet<String>();
        for (TFile file : associationFiles) {
            Map<String, FeOutputJsFileDeclaration> associations = this.readAssociationFile(file);
            Set<String> declarations = associations.keySet();
            Set jsDeclarations = declarations.stream().filter(path -> path.matches(".*\\.[cem]?js$")).collect(Collectors.toSet());
            declaredFiles.addAll(jsDeclarations);
        }
        return declaredFiles;
    }

    private Map<String, FeOutputJsFileDeclaration> readAssociationFile(TFile file) throws MojoExecutionException {
        try {
            TFileReader reader = new TFileReader(file);
            return (Map)this.objectMapper.readValue((Reader)reader, (TypeReference)new TypeReference<Map<String, FeOutputJsFileDeclaration>>(){});
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading:\n" + file + "\n" + e);
        }
    }
}

