/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification;

import com.atlassian.maven.plugins.amps.frontend.association.verification.ArtifactScanner;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsChecker;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsReader;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ArtifactScanResults;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.FailurePreferences;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ModuleScanResults;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.ArtifactPathUtils;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.TrueZipUtils;
import com.google.common.annotations.VisibleForTesting;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="verify-fe-manifest-associations", requiresProject=false)
public class VerifyFeManifestAssociationsMojo
extends AbstractMojo {
    @Parameter(property="verify.fe.manifest.associations.inputEntrypoint", alias="verifyFeManifestAssociationsInputEntrypoint", required=true)
    private String inputEntrypoint;
    @Parameter(property="verify.fe.manifest.associations.failOnUndeclaredFiles", alias="verifyFeManifestAssociationsFailOnUndeclaredFiles", defaultValue="true")
    private Boolean failOnUndeclaredFiles;
    @Parameter(property="verify.fe.manifest.associations.failOnExtraDeclarations", alias="verifyFeManifestAssociationsFailOnExtraDeclarations", defaultValue="true")
    private Boolean failOnExtraDeclarations;
    private final Logger logger = LoggerFactory.getLogger((String)"ROOT");
    @Component
    private ArtifactScanner artifactScanner;
    @Component
    private DeclarationsReader declarationsReader;
    @Component
    private DeclarationsChecker declarationsChecker;

    public void execute() throws MojoExecutionException {
        this.logger.info("Verifying frontend manifest associations for an artifact: {}", (Object)this.inputEntrypoint);
        FailurePreferences failurePreferences = new FailurePreferences(this.failOnUndeclaredFiles, this.failOnExtraDeclarations);
        this.verifyManifestAssociations(this.inputEntrypoint, failurePreferences);
    }

    @VisibleForTesting
    protected void verifyManifestAssociations(String inputEntrypoint, FailurePreferences failurePreferences) throws MojoExecutionException {
        TrueZipUtils.configureTrueZip();
        this.declarationsChecker.setFailurePreferences(failurePreferences);
        try {
            this.scanEntrypoint(inputEntrypoint);
            this.declarationsChecker.finalizeChecks();
        }
        finally {
            TrueZipUtils.unmountTrueZip();
        }
    }

    private void scanEntrypoint(String inputEntrypoint) throws MojoExecutionException {
        ArrayDeque<TFile> queue = new ArrayDeque<TFile>();
        TFile root = new TFile(inputEntrypoint);
        queue.add(root);
        while (!queue.isEmpty()) {
            TFile currentArtifact = (TFile)queue.poll();
            ArtifactScanResults scanResults = this.artifactScanner.scan(currentArtifact);
            queue.addAll(scanResults.getArchiveFiles());
            this.verifyModules(scanResults.getModules());
        }
    }

    private void verifyModules(Map<TFile, ModuleScanResults> modules) throws MojoExecutionException {
        for (Map.Entry<TFile, ModuleScanResults> module : modules.entrySet()) {
            TFile moduleRoot = module.getKey();
            ModuleScanResults moduleScanResults = module.getValue();
            Set<String> moduleRelativeDeclarations = this.declarationsReader.readRelativeDeclarations(moduleScanResults.getAssociationFiles(), moduleRoot);
            Set<String> moduleRelativeJsFiles = ArtifactPathUtils.getRelativePaths(moduleScanResults.getJavascriptFiles(), moduleRoot);
            this.declarationsChecker.verifyModule(moduleRoot, moduleRelativeDeclarations, moduleRelativeJsFiles);
        }
    }
}

