/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.mapping.utils;

import com.atlassian.maven.plugins.amps.MavenContext;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DirectoryHelper {
    public static final String ASSOCIATIONS_OUTPUT_DIR = "META-INF/fe-manifest-associations";
    public static final String WEBPACK_CONFIGURATIONS_DIR = "META-INF/fe-manifest-associations";
    private final MavenContext mavenContext;

    public DirectoryHelper(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public String getOutputFileAbsolutePath(String filepath) {
        return Paths.get(this.getOutputDirectoryPath(), filepath).toAbsolutePath().toString();
    }

    public String getOutputDirectoryPath() {
        return this.mavenContext.getProject().getBuild().getOutputDirectory();
    }

    public String getSourceFileAbsolutePath(String filepath) {
        Path path = Paths.get(filepath, new String[0]);
        Path outputPath = path.isAbsolute() ? path : Paths.get(this.getSourceDirectoryPath(), new String[0]).resolve(filepath);
        return outputPath.normalize().toString();
    }

    public String getSourceDirectoryPath() {
        return this.mavenContext.getProject().getBasedir().getAbsolutePath();
    }

    public String getPathRelativeToSourceDirectory(String filepath) {
        Path sourceDirectoryPath;
        Path absolutePath = Paths.get(filepath, new String[0]);
        if (!absolutePath.startsWith(sourceDirectoryPath = Paths.get(this.getSourceDirectoryPath(), new String[0]))) {
            throw new RuntimeException("getPathRelativeToSourceDirectory: input path should be under the source directory " + sourceDirectoryPath + " but got " + filepath);
        }
        Path relativePath = sourceDirectoryPath.relativize(absolutePath);
        return relativePath.normalize().toString();
    }
}

