/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.mapping;

import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.ExternalFeManifestAssociationConfiguration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociation;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociationParameter;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.WebpackFeManifestAssociationConfiguration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.JsonParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;

public class FeManifestAssociationReader {
    private static final String WEBPACK_CONFIGURATIONS_SUFFIX = "-webpack.intermediary.json";
    private final DirectoryHelper directoryHelper;
    private final JsonParser jsonParser;

    public FeManifestAssociationReader(DirectoryHelper directoryHelper, JsonParser jsonParser) {
        this.directoryHelper = directoryHelper;
        this.jsonParser = jsonParser;
    }

    public List<FeManifestAssociation> getManifestAssociations(List<FeManifestAssociationParameter> manifestAssociationConfigurations) throws MojoExecutionException {
        List<FeManifestAssociation> fromConfiguration = this.getManifestAssociationsFromConfiguration(manifestAssociationConfigurations);
        List<FeManifestAssociation> fromWebpackAssociations = this.getManifestAssociationsFromWebpackConfigurations(this.directoryHelper.getOutputFileAbsolutePath("META-INF/fe-manifest-associations"));
        return Stream.of(fromConfiguration.stream(), fromWebpackAssociations.stream()).flatMap(i -> i).collect(Collectors.toList());
    }

    @Nonnull
    @VisibleForTesting
    protected List<FeManifestAssociation> getManifestAssociationsFromWebpackConfigurations(String webpackConfigurationsPath) throws MojoExecutionException {
        File[] directoryFiles;
        File webpackDirectory = new File(webpackConfigurationsPath);
        ArrayList<FeManifestAssociation> manifestAssociations = new ArrayList<FeManifestAssociation>();
        if (webpackDirectory.exists() && webpackDirectory.isDirectory() && (directoryFiles = webpackDirectory.listFiles()) != null) {
            for (File fileEntry : directoryFiles) {
                if (fileEntry.isDirectory() || !fileEntry.getName().endsWith(WEBPACK_CONFIGURATIONS_SUFFIX)) continue;
                manifestAssociations.add(this.getManifestAssociationFromWebpackConfiguration(fileEntry.getAbsolutePath()));
            }
        }
        return manifestAssociations;
    }

    private FeManifestAssociation getManifestAssociationFromWebpackConfiguration(String webpackConfigurationAbsPath) throws MojoExecutionException {
        WebpackFeManifestAssociationConfiguration webpackConfiguration;
        File webpackConfigurationFile = new File(webpackConfigurationAbsPath);
        try {
            webpackConfiguration = this.jsonParser.readFile(webpackConfigurationFile, WebpackFeManifestAssociationConfiguration.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Webpack manifest association couldn't be parsed. Path: %s", webpackConfigurationAbsPath));
        }
        return new FeManifestAssociation(webpackConfiguration.getPackageName(), webpackConfiguration.getOutputDirectoryFiles(), this.directoryHelper.getPathRelativeToSourceDirectory(webpackConfigurationFile.getAbsolutePath()));
    }

    @Nonnull
    @VisibleForTesting
    protected FeManifestAssociation getManifestAssociationsFromExternalConfiguration(String externalConfigurationPath) throws MojoExecutionException {
        ExternalFeManifestAssociationConfiguration externalConfiguration;
        String externalConfigurationAbsolutePath = this.directoryHelper.getSourceFileAbsolutePath(externalConfigurationPath);
        File externalConfigurationFile = new File(externalConfigurationAbsolutePath);
        try {
            externalConfiguration = this.jsonParser.readFile(externalConfigurationFile, ExternalFeManifestAssociationConfiguration.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("External manifest association couldn't be parsed. Path: %s", externalConfigurationAbsolutePath));
        }
        return new FeManifestAssociation(externalConfiguration.getPackageName(), externalConfiguration.getManuallyVerifiedEveryFileHasItsDependenciesDeclaredInTheManifest().getOutputDirectoryFiles(), this.directoryHelper.getPathRelativeToSourceDirectory(externalConfigurationPath));
    }

    @Nonnull
    private List<FeManifestAssociation> getManifestAssociationsFromConfiguration(List<FeManifestAssociationParameter> manifestAssociationConfigurations) throws MojoExecutionException {
        ArrayList<FeManifestAssociation> manifestAssociations = new ArrayList<FeManifestAssociation>();
        HashSet<String> externalConfigurations = new HashSet<String>();
        if (manifestAssociationConfigurations != null) {
            for (FeManifestAssociationParameter associationConfiguration : manifestAssociationConfigurations) {
                if (associationConfiguration.getOutputDirectoryFilesDeclaration() != null) {
                    externalConfigurations.add(associationConfiguration.getOutputDirectoryFilesDeclaration());
                    continue;
                }
                manifestAssociations.add(this.createManifestAssociationFromConfiguration(associationConfiguration));
            }
        }
        for (String externalConfiguration : externalConfigurations) {
            FeManifestAssociation manifestAssociation = this.getManifestAssociationsFromExternalConfiguration(externalConfiguration);
            manifestAssociations.add(manifestAssociation);
        }
        return manifestAssociations;
    }

    private FeManifestAssociation createManifestAssociationFromConfiguration(FeManifestAssociationParameter associationConfiguration) {
        return new FeManifestAssociation(associationConfiguration.getPackageName(), associationConfiguration.getFilesDeclaration().getOutputDirectoryFiles().stream().filter(path -> path != null && !path.isEmpty()).map(String::trim).collect(Collectors.toList()), "pom.xml");
    }
}

