/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.analytics.visitordata;

import com.atlassian.maven.plugins.amps.analytics.visitordata.VisitorDataDao;
import com.atlassian.maven.plugins.amps.analytics.visitordata.VisitorDataMarshaller;
import com.atlassian.maven.plugins.amps.util.VisitorDataDaoPreferencesNode;
import com.dmurph.tracking.VisitorData;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.plugin.logging.Log;

@ParametersAreNonnullByDefault
public class PreferencesVisitorDataDao
implements VisitorDataDao {
    @VisibleForTesting
    static final String PREF_NAME = "ga_visitor_data";
    private final Log log;
    private final VisitorDataMarshaller marshaller;

    public PreferencesVisitorDataDao(Log log, VisitorDataMarshaller marshaller) {
        this.log = Objects.requireNonNull(log);
        this.marshaller = Objects.requireNonNull(marshaller);
    }

    @Override
    @Nonnull
    public VisitorData load() {
        VisitorData visitorData;
        String persistedVisitorData = PreferencesVisitorDataDao.getPreferencesPersistenceNode().get(PREF_NAME, null);
        if (persistedVisitorData == null) {
            visitorData = VisitorData.newVisitor();
            this.save(visitorData);
        } else {
            try {
                visitorData = this.marshaller.unmarshalAndUpdate(persistedVisitorData);
            }
            catch (Exception e) {
                this.log.warn((CharSequence)"Couldn't parse visitor data from prefs; deleting");
                PreferencesVisitorDataDao.updatePrefs(prefs -> prefs.remove(PREF_NAME));
                visitorData = VisitorData.newVisitor();
                this.save(visitorData);
            }
        }
        return visitorData;
    }

    @Override
    public void save(VisitorData visitor) {
        PreferencesVisitorDataDao.updatePrefs(prefs -> prefs.put(PREF_NAME, this.marshaller.marshal(visitor)));
    }

    private static void updatePrefs(Consumer<Preferences> updater) {
        Preferences prefs = PreferencesVisitorDataDao.getPreferencesPersistenceNode();
        try {
            updater.accept(prefs);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    @VisibleForTesting
    static Preferences getPreferencesPersistenceNode() {
        return Preferences.userNodeForPackage(VisitorDataDaoPreferencesNode.class);
    }
}

