/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionUtils.class);
    private static final String RESOURCE_NAME = "META-INF/maven/com.atlassian.maven.plugins/amps-maven-plugin/pom.properties";

    private VersionUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        ClassLoader classLoader = VersionUtils.class.getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(RESOURCE_NAME);){
            if (in == null) return "RELEASE";
            Properties props = new Properties();
            props.load(in);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't read version from {}", (Object)RESOURCE_NAME, (Object)e);
        }
        return "RELEASE";
    }
}

