/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.manager;

import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.product.manager.Container;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ContainerConfig {
    private final Container container;
    private final Product product;
    private final int nodeIndex;

    ContainerConfig(Container container, Product product, int nodeIndex) {
        this.container = Objects.requireNonNull(container);
        this.product = Objects.requireNonNull(product);
        this.nodeIndex = nodeIndex;
    }

    public Container getContainer() {
        return this.container;
    }

    public Product getProduct() {
        return this.product;
    }

    public String getInstallDirectory(String buildDirectory) {
        String baseInstallDirectory = this.container.getInstallDirectory(buildDirectory);
        if (this.nodeIndex == 0) {
            return baseInstallDirectory;
        }
        return baseInstallDirectory + "-" + this.nodeIndex;
    }

    @Nullable
    public String getLogFile() {
        String baseLogFile = this.product.getOutput();
        if (baseLogFile == null || this.nodeIndex == 0) {
            return baseLogFile;
        }
        return baseLogFile + "-" + this.nodeIndex;
    }

    @Nonnull
    public String getConfigDirectory(String buildDirectory) {
        String baseConfigDirectory = this.container.getConfigDirectory(buildDirectory, this.product.getInstanceId());
        if (this.nodeIndex == 0) {
            return baseConfigDirectory;
        }
        return baseConfigDirectory + "-" + this.nodeIndex;
    }

    public boolean isFirstNode() {
        return this.nodeIndex == 0;
    }

    @Nonnull
    public Node getNode() {
        return this.product.getNodes().get(this.nodeIndex);
    }
}

