/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentProcessor;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentTransformer;
import java.io.File;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Element;
import org.dom4j.Node;

@ParametersAreNonnullByDefault
public class ConfluenceClusterConfigurer {
    private static String propertyCalled(String name) {
        return String.format("//property[@name='%s']", name);
    }

    public void configure(File configFile, File sharedHome, String loopbackInterface) throws MojoExecutionException {
        new XMLDocumentProcessor(new XMLDocumentHandler(configFile)).load().transform(this.setSetupTypeToCluster()).transform(this.enableClustering()).transform(this.setSharedHome(sharedHome)).transform(this.setClusterInterface(loopbackInterface)).transform(this.setClusterJoinType()).transform(this.setClusterPeers()).transform(this.removeClusterAddress()).saveIfModified();
    }

    private XMLDocumentTransformer setSetupTypeToCluster() {
        return document -> {
            Element rootElement = document.getRootElement();
            Node setupTypeNode = rootElement.selectSingleNode("//setupType");
            if (setupTypeNode == null) {
                Element newElement = rootElement.addElement("setupType");
                newElement.setText("cluster");
                return true;
            }
            if ("cluster".equals(setupTypeNode.getText())) {
                return false;
            }
            setupTypeNode.setText("cluster");
            return true;
        };
    }

    private XMLDocumentTransformer enableClustering() {
        return document -> this.setProperty((Node)document, "confluence.cluster", "true");
    }

    private XMLDocumentTransformer setSharedHome(File sharedHome) {
        return document -> this.setProperty((Node)document, "confluence.cluster.home", sharedHome.getAbsolutePath());
    }

    private XMLDocumentTransformer setClusterInterface(String loopbackInterface) {
        return document -> this.setProperty((Node)document, "confluence.cluster.interface", loopbackInterface);
    }

    private XMLDocumentTransformer setClusterJoinType() {
        return document -> this.setProperty((Node)document, "confluence.cluster.join.type", "tcp_ip");
    }

    private XMLDocumentTransformer setClusterPeers() {
        return document -> this.setProperty((Node)document, "confluence.cluster.peers", "127.0.0.1");
    }

    private boolean setProperty(Node document, String name, String value) {
        Node propertiesNode = document.selectSingleNode("//properties");
        if (propertiesNode == null) {
            throw new IllegalStateException("Could not find properties node");
        }
        Node nodeToUpdate = propertiesNode.selectSingleNode(ConfluenceClusterConfigurer.propertyCalled(name));
        if (nodeToUpdate == null) {
            Element newElement = ((Element)propertiesNode).addElement("property");
            newElement.addAttribute("name", name);
            newElement.setText(value);
            return true;
        }
        if (value.equals(nodeToUpdate.getText())) {
            return false;
        }
        nodeToUpdate.setText(value);
        return true;
    }

    private XMLDocumentTransformer removeClusterAddress() {
        return document -> {
            Node clusterAddressNode = document.selectSingleNode(ConfluenceClusterConfigurer.propertyCalled("confluence.cluster.address"));
            if (clusterAddressNode == null) {
                return false;
            }
            clusterAddressNode.detach();
            return true;
        };
    }
}

