/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.BannedDependencies;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.PdkParams;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.minifier.MinifierParameters;
import com.atlassian.maven.plugins.amps.minifier.ResourcesMinifier;
import com.atlassian.maven.plugins.amps.product.manager.BaseUrlUtils;
import com.atlassian.maven.plugins.amps.util.AmpsCreatePluginPrompter;
import com.atlassian.maven.plugins.amps.util.CreatePluginProperties;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.MojoExecutorWrapper;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.archetype.common.DefaultPomManager;
import org.apache.maven.archetype.common.MavenJDOMWriter;
import org.apache.maven.archetype.common.util.Format;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenGoals {
    public static final String REGEX_INTEGRATION_TESTS = "%regex[it[/\\\\].*]";
    private static final String ABSTRACT_CLASSES = "**/Abstract*";
    private static final String INNER_CLASSES = "**/*$*";
    private static final String REPORTS_DIRECTORY = "reportsDirectory";
    private final MavenContext ctx;
    private final Log log;
    private final MojoExecutorWrapper mojoExecutorWrapper;

    public MavenGoals(MavenContext ctx, MojoExecutorWrapper mojoExecutorWrapper) {
        this.ctx = Objects.requireNonNull(ctx);
        this.log = ctx.getLog();
        this.mojoExecutorWrapper = Objects.requireNonNull(mojoExecutorWrapper);
    }

    private MojoExecutor.ExecutionEnvironment executionEnvironment() {
        return this.ctx.getExecutionEnvironment();
    }

    public MavenProject getContextProject() {
        return this.ctx.getProject();
    }

    public void executeAmpsRecursively(String ampsVersion, String ampsGoal, Xpp3Dom configuration) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("amps-maven-plugin"), MojoExecutor.version(ampsVersion)), MojoExecutor.goal(ampsGoal), configuration, this.executionEnvironment());
    }

    public void createPlugin(String productId, AmpsCreatePluginPrompter createPrompter) throws MojoExecutionException {
        CreatePluginProperties props = null;
        Properties systemProps = System.getProperties();
        if (systemProps.containsKey("groupId") && systemProps.containsKey("artifactId") && systemProps.containsKey("version") && systemProps.containsKey("package")) {
            props = new CreatePluginProperties(systemProps.getProperty("groupId"), systemProps.getProperty("artifactId"), systemProps.getProperty("version"), systemProps.getProperty("package"), systemProps.getProperty("useOsgiJavaConfig", "N"));
        }
        if (props == null) {
            try {
                props = createPrompter.prompt();
            }
            catch (PrompterException e) {
                throw new MojoExecutionException("Unable to gather properties", (Exception)((Object)e));
            }
        }
        if (props != null) {
            MojoExecutor.ExecutionEnvironment execEnv = this.executionEnvironment();
            Properties userProperties = execEnv.getMavenSession().getUserProperties();
            userProperties.setProperty("groupId", props.getGroupId());
            userProperties.setProperty("artifactId", props.getArtifactId());
            userProperties.setProperty("version", props.getVersion());
            userProperties.setProperty("package", props.getThePackage());
            userProperties.setProperty("useOsgiJavaConfig", props.getUseOsgiJavaConfigInMavenInvocationFormat());
            this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-archetype-plugin"), MojoExecutor.goal("generate"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archetypeGroupId"), "com.atlassian.maven.archetypes"), MojoExecutor.element(MojoExecutor.name("archetypeArtifactId"), (productId.equals("all") ? "" : productId + "-") + "plugin-archetype"), MojoExecutor.element(MojoExecutor.name("archetypeVersion"), VersionUtils.getVersion()), MojoExecutor.element(MojoExecutor.name("interactiveMode"), "false")), execEnv);
            this.correctCrlf(props.getArtifactId());
            File pluginDir = new File(this.ctx.getProject().getBasedir(), props.getArtifactId());
            if (pluginDir.exists()) {
                File src = new File(pluginDir, "src");
                File test = new File(src, "test");
                File java = new File(test, "java");
                String packagePath = props.getThePackage().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                File packageFile = new File(java, packagePath);
                File packageUT = new File(packageFile, "ut");
                File packageIT = new File(packageFile, "it");
                File ut = new File(new File(java, "ut"), packagePath);
                File it = new File(new File(java, "it"), packagePath);
                if (packageFile.exists()) {
                    try {
                        if (packageUT.exists()) {
                            org.apache.commons.io.FileUtils.copyDirectory((File)packageUT, (File)ut);
                        }
                        if (packageIT.exists()) {
                            org.apache.commons.io.FileUtils.copyDirectory((File)packageIT, (File)it);
                        }
                        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"it")), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"ut"))});
                        FileUtils.cleanDirectory(java, (FileFilter)filter);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void correctCrlf(String artifactId) {
        File outputDirectoryFile;
        if (this.ctx != null && this.ctx.getProject() != null && this.ctx.getProject().getBasedir() != null && this.ctx.getProject().getBasedir().exists() && (outputDirectoryFile = new File(this.ctx.getProject().getBasedir(), artifactId)).exists()) {
            FilenameFilter pomFilter = (dir, name) -> "pom.xml".equals(name);
            File[] pomFiles = outputDirectoryFile.listFiles(pomFilter);
            DefaultPomManager pomManager = new DefaultPomManager();
            for (File pom : pomFiles) {
                this.processCorrectCrlf(pomManager, pom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCorrectCrlf(DefaultPomManager pomManager, File pom) {
        block5: {
            FileInputStream inputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                Model model = pomManager.readPom(pom);
                String fileEncoding = StringUtils.isEmpty((CharSequence)model.getModelEncoding()) ? model.getModelEncoding() : "UTF-8";
                inputStream = new FileInputStream(pom);
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((InputStream)inputStream);
                MavenJDOMWriter writer = new MavenJDOMWriter();
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pom), fileEncoding);
                Format form = Format.getRawFormat().setEncoding(fileEncoding);
                form.setLineSeparator("\n");
                writer.write(model, doc, (Writer)outputStreamWriter, form);
                IOUtil.close((InputStream)inputStream);
            }
            catch (Exception e) {
                this.log.error((CharSequence)"Have exception when try correct line ending.", (Throwable)e);
                break block5;
            }
            finally {
                IOUtil.close(inputStream);
                IOUtil.close(outputStreamWriter);
            }
            IOUtil.close((Writer)outputStreamWriter);
        }
    }

    public void copyBundledDependencies() throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}/META-INF/lib")), this.executionEnvironment());
    }

    public void validateBannedDependencies(Set<String> banExcludes) throws MojoExecutionException {
        this.log.info((CharSequence)"validate banned dependencies");
        this.mojoExecutorWrapper.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-enforcer-plugin"), MojoExecutor.version("3.0.0-M3")), MojoExecutor.goal("enforce"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("rules"), MojoExecutor.element(MojoExecutor.name("bannedDependencies"), MojoExecutor.element(MojoExecutor.name("searchTransitive"), "true"), MojoExecutor.element(MojoExecutor.name("message"), "make sure platform artifacts are not bundled into plugin"), MojoExecutor.element(MojoExecutor.name("excludes"), BannedDependencies.getBannedElements(banExcludes).toArray(new MojoExecutor.Element[0]))))), this.executionEnvironment());
    }

    public void copyTestBundledDependencies(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            this.log.info((CharSequence)("excluding artifact from test jar: " + artifact.getArtifactId()));
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("useSubDirectoryPerScope"), "true"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}/testlibs")), this.executionEnvironment());
        File targetDir = new File(this.ctx.getProject().getBuild().getDirectory());
        File testlibsDir = new File(targetDir, "testlibs");
        File compileLibs = new File(testlibsDir, "compile");
        File testLibs = new File(testlibsDir, "test");
        File testClassesDir = new File(this.ctx.getProject().getBuild().getTestOutputDirectory());
        File metainfDir = new File(testClassesDir, "META-INF");
        File libDir = new File(metainfDir, "lib");
        try {
            compileLibs.mkdirs();
            testLibs.mkdirs();
            libDir.mkdirs();
            org.apache.commons.io.FileUtils.copyDirectory((File)compileLibs, (File)libDir);
            org.apache.commons.io.FileUtils.copyDirectory((File)testLibs, (File)libDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to copy test libs", (Exception)e);
        }
    }

    public void copyTestBundledDependenciesExcludingTestScope(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            this.log.info((CharSequence)("excluding artifact from test jar: " + artifact.getArtifactId()));
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}/META-INF/lib")), this.executionEnvironment());
    }

    private void extractDependencies(Xpp3Dom configuration) throws MojoExecutionException {
        Xpp3Dom copyOfConfiguration = new Xpp3Dom(configuration);
        this.doExtractDependencies(configuration);
        this.warnAboutOverwrites(copyOfConfiguration);
    }

    private void warnAboutOverwrites(Xpp3Dom configuration) throws MojoExecutionException {
        Path tempDirectory = this.createTempDirectoryForOverwriteDetection();
        configuration.getChild("outputDirectory").setValue(tempDirectory.toString());
        configuration.addChild(MojoExecutor.element("useSubDirectoryPerArtifact", "true").toDom());
        configuration.addChild(MojoExecutor.element("overWriteReleases", "true").toDom());
        configuration.addChild(MojoExecutor.element("overWriteSnapshots", "true").toDom());
        configuration.addChild(MojoExecutor.element("silent", "true").toDom());
        this.doExtractDependencies(configuration);
        this.checkForOverwrites(tempDirectory);
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)tempDirectory.toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkForOverwrites(Path dependencyDirectory) {
        try (Stream<Path> fileStream = Files.walk(dependencyDirectory, new FileVisitOption[0]);){
            Map<Path, Set> artifactsByPath = fileStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dependencyDirectory::relativize).collect(Collectors.groupingBy(MavenGoals::tail, Collectors.mapping(MavenGoals::head, Collectors.toCollection(TreeSet::new))));
            Map<Path, Set<Path>> clashes = artifactsByPath.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!clashes.isEmpty()) {
                this.logWarnings(clashes);
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private void logWarnings(Map<Path, Set<Path>> clashes) {
        this.log.warn((CharSequence)"Extracting your plugin's dependencies caused the following file(s) to overwrite each other:");
        clashes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.log.warn((CharSequence)String.format("-- %s from %s", e.getKey(), e.getValue())));
        this.log.warn((CharSequence)"To prevent this, set <extractDependencies> to false in your AMPS configuration");
    }

    private static Path head(Path path) {
        return path.subpath(0, 1);
    }

    private static Path tail(Path path) {
        return path.subpath(1, path.getNameCount());
    }

    private Path createTempDirectoryForOverwriteDetection() {
        Path targetDirectory = Paths.get(this.ctx.getProject().getBuild().getDirectory(), new String[0]);
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            return Files.createTempDirectory(targetDirectory, "amps-overwrite-detection-", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void doExtractDependencies(Xpp3Dom configuration) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("unpack-dependencies"), configuration, this.executionEnvironment());
    }

    public void extractBundledDependencies() throws MojoExecutionException {
        this.extractDependencies(MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludes"), "atlassian-plugin.xml, module-info.class, META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")));
    }

    public void extractTestBundledDependenciesExcludingTestScope(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        this.extractDependencies(MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("excludes"), "atlassian-plugin.xml, module-info.class, META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}")));
    }

    public void extractTestBundledDependencies(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        this.extractDependencies(MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("useSubDirectoryPerScope"), "true"), MojoExecutor.element(MojoExecutor.name("excludes"), "atlassian-plugin.xml, module-info.class, META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}/testlibs")));
        File targetDir = new File(this.ctx.getProject().getBuild().getDirectory());
        File testlibsDir = new File(targetDir, "testlibs");
        File compileLibs = new File(testlibsDir, "compile");
        File testLibs = new File(testlibsDir, "test");
        File testClassesDir = new File(this.ctx.getProject().getBuild().getTestOutputDirectory());
        try {
            compileLibs.mkdirs();
            testLibs.mkdirs();
            org.apache.commons.io.FileUtils.copyDirectory((File)compileLibs, (File)testClassesDir, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"META-INF")));
            org.apache.commons.io.FileUtils.copyDirectory((File)testLibs, (File)testClassesDir, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"META-INF")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to copy test libs", (Exception)e);
        }
    }

    public void compressResources(boolean compressJs, boolean compressCss, boolean useClosureForJs, Charset cs, Map<String, String> closureOptions) throws MojoExecutionException {
        MinifierParameters minifierParameters = new MinifierParameters(compressJs, compressCss, useClosureForJs, cs, this.log, closureOptions);
        new ResourcesMinifier(minifierParameters).minify(this.ctx.getProject().getBuild().getResources(), this.ctx.getProject().getBuild().getOutputDirectory());
    }

    public void filterPluginDescriptor() throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-resources-plugin"), MojoExecutor.goal("copy-resources"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("encoding"), "UTF-8"), MojoExecutor.element(MojoExecutor.name("resources"), MojoExecutor.element(MojoExecutor.name("resource"), MojoExecutor.element(MojoExecutor.name("directory"), "src/main/resources"), MojoExecutor.element(MojoExecutor.name("filtering"), "true"), MojoExecutor.element(MojoExecutor.name("includes"), MojoExecutor.element(MojoExecutor.name("include"), "atlassian-plugin.xml")))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")), this.executionEnvironment());
        XmlCompressor compressor = new XmlCompressor();
        File pluginXmlFile = new File(this.ctx.getProject().getBuild().getOutputDirectory(), "atlassian-plugin.xml");
        if (pluginXmlFile.exists()) {
            try {
                String source = org.apache.commons.io.FileUtils.readFileToString((File)pluginXmlFile, (Charset)StandardCharsets.UTF_8);
                String min = compressor.compress(source);
                org.apache.commons.io.FileUtils.writeStringToFile((File)pluginXmlFile, (String)min, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException while minifying plugin XML file", (Exception)e);
            }
        }
    }

    public void filterTestPluginDescriptor() throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-resources-plugin"), MojoExecutor.goal("copy-resources"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("encoding"), "UTF-8"), MojoExecutor.element(MojoExecutor.name("resources"), MojoExecutor.element(MojoExecutor.name("resource"), MojoExecutor.element(MojoExecutor.name("directory"), "src/test/resources"), MojoExecutor.element(MojoExecutor.name("filtering"), "true"), MojoExecutor.element(MojoExecutor.name("includes"), MojoExecutor.element(MojoExecutor.name("include"), "atlassian-plugin.xml")))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}")), this.executionEnvironment());
    }

    public void runUnitTests(Map<String, Object> systemProperties, String excludedGroups, String category) throws MojoExecutionException {
        MojoExecutor.Element systemProps = this.convertPropsToElements(systemProperties);
        Xpp3Dom config = MojoExecutor.configuration(systemProps, MojoExecutor.element(MojoExecutor.name("excludes"), MojoExecutor.element(MojoExecutor.name("exclude"), REGEX_INTEGRATION_TESTS), MojoExecutor.element(MojoExecutor.name("exclude"), INNER_CLASSES)), MojoExecutor.element(MojoExecutor.name("excludedGroups"), excludedGroups));
        if (StringUtils.isNotBlank((CharSequence)category)) {
            config.addChild(this.groupsElement(category));
        }
        Plugin surefirePlugin = this.ctx.getPlugin("org.apache.maven.plugins", "maven-surefire-plugin");
        this.log.info((CharSequence)("Surefire " + surefirePlugin.getVersion() + " test configuration:"));
        this.log.info((CharSequence)config.toString());
        this.mojoExecutorWrapper.executeWithMergedConfig(surefirePlugin, MojoExecutor.goal("test"), config, this.executionEnvironment());
    }

    @Nonnull
    public File copyWebappWar(ProductArtifact artifact, File targetDirectory, String productId) throws MojoExecutionException {
        File destinationFile = new File(targetDirectory, productId + "-original.war");
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), destinationFile.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath())), this.executionEnvironment());
        return destinationFile;
    }

    public void unpackWebappWar(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("unpack"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath()), MojoExecutor.element(MojoExecutor.name("overWriteReleases"), "true"), MojoExecutor.element(MojoExecutor.name("overWriteSnapshots"), "true"), MojoExecutor.element(MojoExecutor.name("useJvmChmod"), "true")), this.executionEnvironment());
    }

    public void copyPlugins(File outputDirectory, List<ProductArtifact> artifacts) throws MojoExecutionException {
        for (ProductArtifact artifact : artifacts) {
            MavenProject artifactReactorProject = this.getReactorProjectForArtifact(artifact);
            if (artifactReactorProject != null) {
                this.log.debug((CharSequence)(artifact + " will be copied from reactor project " + artifactReactorProject));
                File artifactFile = artifactReactorProject.getArtifact().getFile();
                if (artifactFile == null) {
                    this.log.warn((CharSequence)("The plugin " + artifact + " is in the reactor but not the file hasn't been attached.  Skipping."));
                    continue;
                }
                this.log.debug((CharSequence)("Copying " + artifactFile + " to " + outputDirectory));
                try {
                    org.apache.commons.io.FileUtils.copyFile((File)artifactFile, (File)new File(outputDirectory, artifactFile.getName()));
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy " + artifact + " to " + outputDirectory, (Exception)e);
                }
            }
            this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), outputDirectory.getPath())), this.executionEnvironment());
        }
    }

    private MavenProject getReactorProjectForArtifact(ProductArtifact artifact) {
        for (MavenProject project : this.ctx.getReactor()) {
            if (!project.getGroupId().equals(artifact.getGroupId()) || !project.getArtifactId().equals(artifact.getArtifactId()) || !project.getVersion().equals(artifact.getVersion())) continue;
            return project;
        }
        return null;
    }

    private Plugin bndPlugin() {
        Plugin bndPlugin = this.ctx.getPlugin("org.apache.felix", "maven-bundle-plugin");
        this.log.info((CharSequence)("using maven-bundle-plugin v" + bndPlugin.getVersion()));
        return bndPlugin;
    }

    public static String getReportsDirectory(File targetDirectory, String testGroupId, String containerId) {
        return targetDirectory.getAbsolutePath() + "/" + testGroupId + "/" + containerId + "/surefire-reports";
    }

    public void runIntegrationTests(String reportsDirectory, List<String> includes, List<String> excludes, Map<String, Object> systemProperties, String category, @Nullable String debug) throws MojoExecutionException {
        Xpp3Dom integrationTestConfig = this.getIntegrationTestConfig(includes, excludes, systemProperties, category, debug, reportsDirectory);
        Plugin failsafePlugin = this.ctx.getPlugin("org.apache.maven.plugins", "maven-failsafe-plugin");
        this.log.info((CharSequence)("Failsafe " + failsafePlugin.getVersion() + " integration-test configuration:"));
        this.log.info((CharSequence)integrationTestConfig.toString());
        this.mojoExecutorWrapper.executeWithMergedConfig(failsafePlugin, MojoExecutor.goal("integration-test"), integrationTestConfig, this.executionEnvironment());
    }

    public void runVerify(String reportsDirectory) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-failsafe-plugin"), MojoExecutor.goal("verify"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name(REPORTS_DIRECTORY), reportsDirectory)), this.executionEnvironment());
    }

    private Xpp3Dom getIntegrationTestConfig(List<String> includes, List<String> excludes, Map<String, Object> systemProperties, String category, @Nullable String debug, String reportsDirectory) {
        MojoExecutor.Element[] includeElements = (MojoExecutor.Element[])includes.stream().map(include -> MojoExecutor.element(MojoExecutor.name("include"), include)).toArray(MojoExecutor.Element[]::new);
        systemProperties.put(REPORTS_DIRECTORY, reportsDirectory);
        MojoExecutor.Element systemPropsElement = this.convertPropsToElements(systemProperties);
        Xpp3Dom config = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includes"), includeElements), MojoExecutor.element(MojoExecutor.name("excludes"), this.getTestExcludes(excludes)), systemPropsElement, MojoExecutor.element(MojoExecutor.name(REPORTS_DIRECTORY), reportsDirectory));
        if (debug != null) {
            config.addChild(MojoExecutor.element(MojoExecutor.name("debugForkedProcess"), debug).toDom());
        }
        if (StringUtils.isNotBlank((CharSequence)category)) {
            config.addChild(this.groupsElement(category));
        }
        return config;
    }

    private MojoExecutor.Element[] getTestExcludes(List<String> userSpecifiedExcludes) {
        HashSet<String> allExcludes = new HashSet<String>(userSpecifiedExcludes);
        allExcludes.add(ABSTRACT_CLASSES);
        allExcludes.add(INNER_CLASSES);
        return (MojoExecutor.Element[])allExcludes.stream().map(exclude -> MojoExecutor.element(MojoExecutor.name("exclude"), exclude)).toArray(MojoExecutor.Element[]::new);
    }

    private Xpp3Dom groupsElement(String category) {
        return MojoExecutor.element(MojoExecutor.name("groups"), category).toDom();
    }

    private MojoExecutor.Element convertPropsToElements(Map<String, Object> systemProperties) {
        ArrayList<MojoExecutor.Element> properties = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, Object> entry : systemProperties.entrySet()) {
            this.log.info((CharSequence)("adding system property to configuration: " + entry.getKey() + "::" + entry.getValue()));
            properties.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue().toString()));
        }
        return MojoExecutor.element(MojoExecutor.name("systemPropertyVariables"), properties.toArray(new MojoExecutor.Element[0]));
    }

    public void installPlugin(PdkParams pdkParams) throws MojoExecutionException {
        String baseUrl = BaseUrlUtils.getBaseUrl(pdkParams.getServer(), pdkParams.getPort(), pdkParams.getContextPath());
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("com.atlassian.maven.plugins", "atlassian-pdk"), MojoExecutor.goal("install"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("pluginFile"), pdkParams.getPluginFile()), MojoExecutor.element(MojoExecutor.name("username"), pdkParams.getUsername()), MojoExecutor.element(MojoExecutor.name("password"), pdkParams.getPassword()), MojoExecutor.element(MojoExecutor.name("serverUrl"), baseUrl), MojoExecutor.element(MojoExecutor.name("pluginKey"), pdkParams.getPluginKey())), this.executionEnvironment());
    }

    public void installIdeaPlugin() throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.twdata.maven", "maven-cli-plugin"), MojoExecutor.goal("idea"), MojoExecutor.configuration(new MojoExecutor.Element[0]), this.executionEnvironment());
    }

    public File copyZip(File targetDirectory, ProductArtifact artifact, String localName) throws MojoExecutionException {
        File artifactZip = new File(targetDirectory, localName);
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-dependency-plugin"), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "zip"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), artifactZip.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), artifactZip.getParent())), this.executionEnvironment());
        return artifactZip;
    }

    public void generateBundleManifest(Map<String, String> instructions, Map<String, String> basicAttributes) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> instlist = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : instructions.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        if (!instructions.containsKey("Import-Package")) {
            instlist.add(MojoExecutor.element("Import-Package", "*;resolution:=optional"));
        }
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        this.mojoExecutorWrapper.executeWithMergedConfig(this.bndPlugin(), MojoExecutor.goal("manifest"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("supportedProjectTypes"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "jar"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "bundle"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "war"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "atlassian-plugin")), MojoExecutor.element(MojoExecutor.name("instructions"), instlist.toArray(new MojoExecutor.Element[0]))), this.executionEnvironment());
    }

    public void generateTestBundleManifest(Map<String, String> instructions, Map<String, String> basicAttributes) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> instlist = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : instructions.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        if (!instructions.containsKey("Import-Package")) {
            instlist.add(MojoExecutor.element("Import-Package", "*;resolution:=optional"));
        }
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        this.mojoExecutorWrapper.executeWithMergedConfig(this.bndPlugin(), MojoExecutor.goal("manifest"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("manifestLocation"), "${project.build.testOutputDirectory}/META-INF"), MojoExecutor.element(MojoExecutor.name("supportedProjectTypes"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "jar"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "bundle"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "war"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "atlassian-plugin")), MojoExecutor.element(MojoExecutor.name("instructions"), instlist.toArray(new MojoExecutor.Element[0]))), this.executionEnvironment());
    }

    public void generateMinimalManifest(Map<String, String> basicAttributes) throws MojoExecutionException {
        File metaInf = FileUtils.file(this.ctx.getProject().getBuild().getOutputDirectory(), "META-INF");
        if (!metaInf.exists()) {
            metaInf.mkdirs();
        }
        File mf = FileUtils.file(this.ctx.getProject().getBuild().getOutputDirectory(), "META-INF", "MANIFEST.MF");
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            m.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        try (FileOutputStream fos = new FileOutputStream(mf);){
            m.write(fos);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create manifest", (Exception)e);
        }
    }

    public void generateTestMinimalManifest(Map<String, String> basicAttributes) throws MojoExecutionException {
        File metaInf = FileUtils.file(this.ctx.getProject().getBuild().getTestOutputDirectory(), "META-INF");
        if (!metaInf.exists()) {
            metaInf.mkdirs();
        }
        File mf = FileUtils.file(this.ctx.getProject().getBuild().getTestOutputDirectory(), "META-INF", "MANIFEST.MF");
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            m.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        try (FileOutputStream fos = new FileOutputStream(mf);){
            m.write(fos);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create manifest", (Exception)e);
        }
    }

    public void jarWithOptionalManifest(boolean manifestExists) throws MojoExecutionException {
        MojoExecutor.Element[] archive = new MojoExecutor.Element[]{};
        if (manifestExists) {
            archive = new MojoExecutor.Element[]{MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.outputDirectory}/META-INF/MANIFEST.MF")};
        }
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-jar-plugin"), MojoExecutor.goal("jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archive"), archive)), this.executionEnvironment());
    }

    public void jarTests(String finalName) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-jar-plugin"), MojoExecutor.goal("test-jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("finalName"), finalName), MojoExecutor.element(MojoExecutor.name("archive"), MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.testOutputDirectory}/META-INF/MANIFEST.MF"))), this.executionEnvironment());
    }

    public void generateObrXml(File dep, File obrXml) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.bndPlugin(), MojoExecutor.goal("install-file"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("obrRepository"), obrXml.getPath()), MojoExecutor.element(MojoExecutor.name("groupId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("artifactId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("version"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("packaging"), "jar"), MojoExecutor.element(MojoExecutor.name("file"), dep.getPath())), this.executionEnvironment());
    }

    public void attachArtifacts(Collection<File> files, String type) throws MojoExecutionException {
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.codehaus.mojo", "build-helper-maven-plugin"), MojoExecutor.goal("attach-artifact"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifacts"), this.asArtifactElements(files, type))), this.executionEnvironment());
    }

    private MojoExecutor.Element[] asArtifactElements(Collection<File> files, String type) {
        return (MojoExecutor.Element[])files.stream().map(file -> MojoExecutor.element(MojoExecutor.name("artifact"), MojoExecutor.element(MojoExecutor.name("file"), file.getAbsolutePath()), MojoExecutor.element(MojoExecutor.name("type"), type))).toArray(MojoExecutor.Element[]::new);
    }

    public void release(String mavenArgs) throws MojoExecutionException {
        String args = "";
        if (StringUtils.isNotBlank((CharSequence)mavenArgs)) {
            args = mavenArgs;
        }
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-release-plugin"), MojoExecutor.goal("prepare"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), args), MojoExecutor.element(MojoExecutor.name("autoVersionSubmodules"), "true")), this.executionEnvironment());
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-release-plugin"), MojoExecutor.goal("perform"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), args), MojoExecutor.element(MojoExecutor.name("useReleaseProfile"), "true")), this.executionEnvironment());
    }

    public void debugStandaloneContainer(File pluginFile) throws MojoExecutionException {
        String pluginResourceDirs = this.getContextProject().getResources().stream().map(FileSet::getDirectory).collect(Collectors.joining(","));
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.codehaus.mojo", "exec-maven-plugin"), MojoExecutor.goal("exec"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "java"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name("argument"), "-Datlassian.dev.mode=true"), MojoExecutor.element(MojoExecutor.name("argument"), "-Datlassian.allow.insecure.url.parameter.login=true"), MojoExecutor.element(MojoExecutor.name("argument"), "-Dplugin.resource.directories=" + pluginResourceDirs), MojoExecutor.element(MojoExecutor.name("argument"), "-Xdebug"), MojoExecutor.element(MojoExecutor.name("argument"), "-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5004"), MojoExecutor.element(MojoExecutor.name("argument"), "-jar"), MojoExecutor.element(MojoExecutor.name("argument"), "${project.build.directory}/remotable-plugins-container-standalone.jar"), MojoExecutor.element(MojoExecutor.name("argument"), pluginFile.getPath()))), this.executionEnvironment());
    }

    public File generateEffectivePom(ProductArtifact artifact, File parentDir) throws MojoExecutionException {
        File effectivePom = new File(parentDir, "effectivePom.xml");
        this.mojoExecutorWrapper.executeWithMergedConfig(this.ctx.getPlugin("org.apache.maven.plugins", "maven-help-plugin"), MojoExecutor.goal("effective-pom"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifact"), artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("output"), effectivePom.getAbsolutePath())), this.executionEnvironment());
        return effectivePom;
    }
}

