/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-home-zip")
public class CreateHomeZipMojo
extends AbstractProductHandlerMojo {
    private static final String BASE_ZIP_NAME = "generated-test-resources";
    private static final String DOT_ZIP = ".zip";
    @Parameter(property="homeZip")
    protected File homeZip;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.trackFirstRunIfNeeded();
        Product product = this.getProduct(this.instanceId, this.getProductId());
        ProductHandler productHandler = this.getProductHandler(product.getId());
        List<File> snapshotDirs = productHandler.getSnapshotDirectories(product);
        List<File> homeZips = this.getHomeZips(productHandler.getBaseDirectory(product), snapshotDirs.size());
        for (int i = 0; i < snapshotDirs.size(); ++i) {
            File snapshotDir = snapshotDirs.get(i);
            File thisHomeZip = homeZips.get(i);
            productHandler.createHomeZip(snapshotDir, thisHomeZip, product);
            this.getLog().info((CharSequence)("Home directory zip created successfully at " + thisHomeZip.getAbsolutePath()));
        }
        this.getMavenGoals().attachArtifacts(homeZips, "zip");
    }

    private List<File> getHomeZips(File baseDirectory, int nodeCount) {
        ArrayList<File> homeZips = new ArrayList<File>();
        for (int i = 0; i < nodeCount; ++i) {
            String filename = this.getHomeZipName(i, nodeCount);
            homeZips.add(new File(baseDirectory, filename));
        }
        return homeZips;
    }

    private String getHomeZipName(int nodeIndex, int nodeCount) {
        if (nodeCount == 1) {
            return this.homeZip == null ? "generated-test-resources.zip" : this.homeZip.getName();
        }
        if (this.homeZip != null) {
            this.getLog().warn((CharSequence)String.format("Multi-node operation; Ignoring configured <homeZip> '%s'", this.homeZip));
        }
        if (nodeIndex == 0) {
            return "generated-test-resources.zip";
        }
        return "generated-test-resources-" + nodeIndex + DOT_ZIP;
    }

    private Product getProduct(String instanceId, String productId) throws MojoExecutionException {
        Map<String, Product> contexts = this.getProductContexts();
        Product product = null;
        if (instanceId != null) {
            product = contexts.get(instanceId);
            if (product == null) {
                throw new MojoExecutionException("There is no instance with name " + instanceId + " defined in the pom.xml");
            }
        } else {
            for (Product candidate : contexts.values()) {
                if (!candidate.getId().equals(productId)) continue;
                product = candidate;
                break;
            }
            if (product == null) {
                throw new MojoExecutionException("There is no product with name " + productId + " defined in the pom.xml. Please use -DinstanceId=... to set the instance to snapshot.");
            }
        }
        return product;
    }
}

