/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import java.util.Objects;

public final class JavaModulePackage {
    private static final String ALL_UNNAMED_MODULES = "ALL-UNNAMED";
    private final String moduleName;
    private final String packageName;

    public JavaModulePackage(String moduleName, String packageName) {
        this.moduleName = Objects.requireNonNull(moduleName);
        this.packageName = Objects.requireNonNull(packageName);
    }

    public String createAddOpensToUnnamed() {
        return this.createAddOpens(ALL_UNNAMED_MODULES);
    }

    public String createAddExportsToUnnamed() {
        return this.createAddExports(ALL_UNNAMED_MODULES);
    }

    private String createAddOpens(String targetModule) {
        return String.format("--add-opens %s/%s=%s", this.moduleName, this.packageName, targetModule);
    }

    private String createAddExports(String targetModule) {
        return String.format("--add-exports %s/%s=%s", this.moduleName, this.packageName, targetModule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaModulePackage that = (JavaModulePackage)o;
        return this.moduleName.equals(that.moduleName) && this.packageName.equals(that.packageName);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.packageName);
    }

    static JavaModulePackage fromJavaBaseModule(String packageName) {
        return new JavaModulePackage("java.base", packageName);
    }

    static JavaModulePackage fromJavaRmiModule(String packageName) {
        return new JavaModulePackage("java.rmi", packageName);
    }
}

