/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;

public class BambooProductHandler
extends AbstractWebappProductHandler {
    private static final String BUNDLED_PLUGINS_UNZIPPED = "WEB-INF/atlassian-bundled-plugins";
    private static final String BUNDLED_PLUGINS_ZIP = "WEB-INF/classes/atlassian-bundled-plugins.zip";

    public BambooProductHandler(MavenContext context, MavenGoals goals, RepositorySystem repositorySystem, ArtifactResolver artifactResolver, WebAppManager webAppManager) {
        super(context, goals, new BambooPluginProvider(), repositorySystem, artifactResolver, webAppManager);
    }

    @Override
    @Nonnull
    public String getId() {
        return "bamboo";
    }

    @Override
    @Nonnull
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.bamboo", "atlassian-bamboo-web-app", "RELEASE");
    }

    @Override
    @Nonnull
    public Optional<ProductArtifact> getTestResourcesArtifact() {
        return Optional.of(new ProductArtifact("com.atlassian.bamboo.plugins", "bamboo-plugin-test-resources"));
    }

    @Override
    public int getDefaultHttpPort() {
        return 6990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8446;
    }

    @Override
    @Nonnull
    protected Map<String, String> getProductSpecificSystemProperties(Product product, int nodeIndex) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"bamboo.home", (Object)this.getSingleNodeHomeDirectory(product).getPath());
        properties.put((Object)"org.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES", (Object)"false");
        properties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        properties.put((Object)"file.encoding", (Object)"UTF-8");
        return properties.build();
    }

    @Override
    @Nonnull
    public Optional<File> getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        return Optional.of(new File(homeDir, "plugins"));
    }

    @Override
    @Nonnull
    public File getBundledPluginPath(Product product, File productDir) {
        File bundleDir = new File(productDir, BUNDLED_PLUGINS_UNZIPPED);
        if (bundleDir.isDirectory()) {
            return bundleDir;
        }
        return new File(productDir, BUNDLED_PLUGINS_ZIP);
    }

    @Override
    public void processHomeDirectory(Product product, int nodeIndex, File homeDir) throws MojoExecutionException {
        super.processHomeDirectory(product, nodeIndex, homeDir);
        String contextPath = product.getContextPath().replaceAll("^/|/$", "");
        String baseUrl = String.format("%s://%s:%d/%s", product.getProtocol(), product.getServer(), product.getSingleNodeWebPort(), contextPath);
        File adminXml = new File(homeDir, "/xml-data/configuration/administration.xml");
        ConfigFileUtils.replaceAll(adminXml, "https?://(?:[^:]+|\\[.+]):8085", baseUrl);
    }

    @Override
    @Nonnull
    protected List<ConfigFileUtils.Replacement> getReplacements(@Nonnull Product product, int nodeIndex) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(product, nodeIndex);
        File homeDirectory = this.getSingleNodeHomeDirectory(product);
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", homeDirectory.getParent(), false));
        replacements.add(new ConfigFileUtils.Replacement("/bamboo-home/", "/home/", false));
        replacements.add(new ConfigFileUtils.Replacement("${bambooHome}", homeDirectory.getAbsolutePath(), false));
        return replacements;
    }

    private File getSingleNodeHomeDirectory(@Nonnull Product product) {
        List<File> homeDirectories = this.getHomeDirectories(product);
        if (homeDirectories.size() != 1) {
            throw new IllegalStateException("Expected one home directory, but found " + homeDirectories);
        }
        return homeDirectories.get(0);
    }

    @Override
    @Nonnull
    protected List<File> getConfigFiles(@Nonnull Product product, @Nonnull File homeDirectory) {
        List<File> configFiles = super.getConfigFiles(product, homeDirectory);
        configFiles.add(new File(homeDirectory, "bamboo.cfg.xml"));
        configFiles.add(new File(homeDirectory, "database.log"));
        return configFiles;
    }

    @Override
    protected void cleanupProductHomeForZip(@Nonnull Product bamboo, @Nonnull File genDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(bamboo, genDir);
        FileUtils.deleteDir(new File(genDir, "jms-store"));
        FileUtils.deleteDir(new File(genDir, "caches"));
        FileUtils.deleteDir(new File(genDir, "logs"));
    }

    private static class BambooPluginProvider
    extends AbstractPluginProvider {
        private BambooPluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-bamboo-plugin", salVersion));
        }
    }
}

