package com.atlassian.maven.plugins.amps.product;

import javax.annotation.Nullable;

import static java.util.Arrays.stream;

public enum ImportMethod {
    SQL("sql"), PSQL("psql"), IMPDP("impdp"), SQLCMD("sqlcmd");

    /**
     * Returns the import method with the given name, ignoring case.
     *
     * @param importMethod the name to look up
     * @return null if there's no such import method
     */
    @Nullable
    public static ImportMethod getValueOf(final String importMethod) {
        return stream(values())
                .filter(value -> value.getMethod().equalsIgnoreCase(importMethod))
                .findFirst()
                .orElse(null);
    }

    private final String method;

    ImportMethod(final String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

}
