/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.minifier.strategies.googleclosure;

import com.google.javascript.jscomp.CompilerOptions;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;

public class GoogleClosureOptionsHandler {
    private CompilerOptions compilerOptions;
    private Log log;
    private final Map<String, Consumer<String>> configOptions = new HashMap<String, Consumer<String>>();

    public GoogleClosureOptionsHandler(Log log) {
        this.compilerOptions = new CompilerOptions();
        this.log = log;
        this.compilerOptions.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2018);
        this.compilerOptions.setEmitUseStrict(false);
        this.configOptions.put("emitUseStrict".toLowerCase(), useStrict -> this.compilerOptions.setEmitUseStrict(Boolean.parseBoolean(useStrict)));
        this.configOptions.put("languageIn".toLowerCase(), languageMode -> this.compilerOptions.setLanguageIn(CompilerOptions.LanguageMode.fromString((String)languageMode)));
        this.configOptions.put("languageOut".toLowerCase(), languageMode -> this.compilerOptions.setLanguageOut(CompilerOptions.LanguageMode.fromString((String)languageMode)));
        this.configOptions.put("outputCharset".toLowerCase(), charset -> this.compilerOptions.setOutputCharset(Charset.forName(charset)));
    }

    public void setOption(@Nonnull String optionName, String value) {
        String key = optionName.toLowerCase();
        if (this.configOptions.containsKey(key)) {
            try {
                this.configOptions.get(key).accept(value);
            }
            catch (IllegalArgumentException e) {
                this.log.warn((CharSequence)(optionName + " could not be configured.  Ignoring this option."), (Throwable)e);
            }
        } else {
            this.log.warn((CharSequence)(optionName + " is not configurable. Ignoring this option."));
        }
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }
}

